package com.biz.crm.nebular.sfa.assistant.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 工作任务(发布) 返回vo
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "工作任务(发布) ")
@SaturnEntity(name = "SfaWorkTaskReleaseRespVo", description = "工作任务(发布) ")
public class SfaWorkTaskReleaseRespVo extends CrmExtTenVo {
    @ApiModelProperty("任务标题")
    private String taskTitle;

    @ApiModelProperty("创建时间")
    private String startDate;

    @ApiModelProperty("截至时间")
    private String endDate;

    @ApiModelProperty("任务内容")
    private String content;

    @ApiModelProperty("任务发送人")
    private String senderName;

    @ApiModelProperty("任务进度 100以内数字 省略%")
    private String progress;

    @ApiModelProperty("任务状态 0待执行 1部分完成 2已完成 3未完成 4已拒绝 5已过期")
    @CrmDict(typeCode = "task_status",dictCodeField = "taskStatus")
    private String taskStatus;

    @ApiModelProperty("主id")
    private String taskId;

    @ApiModelProperty("任务照片列表")
    private List<SfaWorkTaskPictureRespVo> pictures;

    @ApiModelProperty("任务详情_人_已执行")
    private List<SfaWorkTaskReceveRespVo> receveRespVos;

    @ApiModelProperty("任务详情_人_未执行")
    private List<SfaWorkTaskReceveRespVo> receveRespNoVos;

    @ApiModelProperty("执行人")
    private String executor;

    @ApiModelProperty("已完成数")
    private String quantityNum;

    @ApiModelProperty("总数")
    private String sumAll;



}