package com.biz.crm.nebular.sfa.activity.resp;

import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.biz.crm.nebular.sfa.visitstep.resp.SfaVisitStepActivityExecutionTypeRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 活动执行;返回vo
 *
 * @author lf
 * @date 2020-12-30 15:24:11
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动执行;")
@SaturnEntity(name = "SfaActivityExecutionRespVo", description = "活动执行;")
public class SfaActivityExecutionRespVo extends CrmExtTenVo {
    @ApiModelProperty("活动名称")
    @SaturnColumn(description = "活动名称")
    private String activityName;

    @ApiModelProperty("活动类型(0-费用活动,1-陈列活动)")
    @SaturnColumn(description = "活动类型(0-费用活动,1-陈列活动)")
    private String activityType;

    @ApiModelProperty("活动类型(0-费用活动,1-陈列活动)")
    @CrmDict(typeCode = "sfa_activity_type",dictCodeField = "activityType")
    private String activityTypeDesc;

    @ApiModelProperty("活动编码")
    private String activityCode;

    @ApiModelProperty("活动状态(0-未开始,1-已开始,2-已结束)")
    private String activityStatus;

    @ApiModelProperty("活动状态(0-未开始,1-已开始,2-已结束)")
    @CrmDict(typeCode = "sfa_activity_status",dictCodeField = "activityStatus")
    private String activityStatusDesc;

    @ApiModelProperty("活动执行开始时间")
    @SaturnColumn(description = "活动执行开始时间")
    private String activityStartTime;

    @ApiModelProperty("活动执行结束时间")
    @SaturnColumn(description = "活动执行结束时间")
    private String activityEndTime;

    @ApiModelProperty("销售额")
    @SaturnColumn(description = "销售额")
    private String salesVolume;

    @ApiModelProperty("申请金额")
    @SaturnColumn(description = "申请金额")
    private String applyAmount;

    @ApiModelProperty("活动要求(0-活动照,1-门头照,2-陈列照)")
    @SaturnColumn(description = "活动要求(0-活动照,1-门头照,2-陈列照)")
    private String activityRequire;

    @ApiModelProperty("活动要求(0-活动照,1-门头照,2-陈列照)")
    @CrmDict(typeCode = "sfa_activity_require",dictCodeField = "activityRequire")
    private String activityRequireDesc;

    @ApiModelProperty("活动描述")
    @SaturnColumn(description = "活动描述")
    private String activityDesc;

    @ApiModelProperty("活动执行频率(天)")
    @SaturnColumn(description = "活动执行频率(天)")
    private String activityFrequency;

    @ApiModelProperty("人员账号")
    @SaturnColumn(description = "人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    @SaturnColumn(description = "人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("活动执行时间")
    private String activityTime;

    @ApiModelProperty("活动范围列表")
    private List<SfaActivityRangeRespVo> activityRangeList;

    @ApiModelProperty("活动产品列表")
    private List<SfaActivityProductRespVo> activityProductList;

    @ApiModelProperty("活动示例图片列表")
    private List<SfaVisitPictureRespVo> visitPictureList;

    @ApiModelProperty("活动执行类型拍照图片列表")
    private List<SfaVisitStepActivityExecutionTypeRespVo> executionTypeList;

    @ApiModelProperty("组织分类范围列表")
    private List<SfaActivityRangeRespVo> orgRangeList;

    @ApiModelProperty("渠道分类范围列表")
    private List<SfaActivityRangeRespVo> channelRangeList;

    @ApiModelProperty("客户分类范围列表")
    private List<SfaActivityRangeRespVo> customerRangeList;

}