package com.biz.crm.nebular.activiti.act.req;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 请求vo
 *
 * @author jerry7
 * @date 2020-12-05 15:36:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TaActBaseProcessReqVo", description = "")
public class TaActBaseProcessReqVo extends PageVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("")
    private String baseId;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("发起人编码")
    private String applierCode;

    @ApiModelProperty("发起人名称")
    private String applierName;

    @ApiModelProperty("发起人职位")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("0=草稿1=暂存2=已提交3=已完成4=驳回5=终止6=撤销")
    private Integer status;

    @ApiModelProperty("")
    private String processKey;

    @ApiModelProperty("流程实例ID")
    private String processInstanceId;

    @ApiModelProperty("")
    private String parentProcessInstanceId;

    @ApiModelProperty("导致流程的原因类型(1=正常发起2=驳回3=转发=4加签5=子流程)")
    private Integer causeType;

    @ApiModelProperty("导致产生流程的职位")
    private String causePositionCode;

    @ApiModelProperty("导致产生流程的职位名称")
    private String causePositionName;

    @ApiModelProperty("导致产生流程的用户账号")
    private String causeUserCode;

    @ApiModelProperty("导致产生流程的用户名称")
    private String causeUserName;

    @ApiModelProperty("发起流程时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    @ApiModelProperty("")
    private String formUrl;

    @ApiModelProperty("流程版本KEY")
    private String processVersionKey;

    @ApiModelProperty("静态HTML快照URL")
    private String htmlUrl;

}