package com.biz.crm.nebular.dms.rebatefeepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.CrmFileVo;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 折扣费用池条目VO
 * @Author: chenrong
 * @Date: 2020/11/23 16:53
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "折扣费用池条目VO")
@JsonIgnoreProperties(ignoreUnknown = true)
public class RebateFeePoolDetailVo extends CrmExtVo {

  private static final long serialVersionUID = -3079031055089868842L;

  /**
   * 折旧费用池编码
   */
  @ApiModelProperty(value = "折旧费用池编码")
  private String rebateFeePoolCode;

  /**
   * 折旧费用池条目code
   */
  @ApiModelProperty(value = "折旧费用池条目code")
  private String code;

  /**
   * 支付方式
   */
  @ApiModelProperty(value = "支付方式")
  private Integer payType;

  /**
   * 条目总金额
   */
  @ApiModelProperty(value = "条目总金额")
  private BigDecimal itemTotalFee = BigDecimal.ZERO;

  /**
   * 条目可用已使用金额
   */
  @ApiModelProperty(value = "条目可用已使用金额")
  private BigDecimal itemUsedFee = BigDecimal.ZERO;

  /**
   * 条目冻结金额
   */
  @ApiModelProperty(value = "条目冻结金额")
  private BigDecimal itemFrozenFee = BigDecimal.ZERO;

  /**
   * 条目可用余额
   */
  @ApiModelProperty(value = "条目可用余额")
  private BigDecimal itemAvailableBalance = BigDecimal.ZERO;

  /**
   * 冗余字段，文件对象集合
   */
  @ApiModelProperty(value = "冗余字段，文件对象集合")
  private List<RebateFeePoolFileVo> files;

  /**
   * 折扣费用池
   */
  @ApiModelProperty(value = "折扣费用池")
  private RebateFeePoolVo rebateFeePoolVo;

  /**
   * 调整类型
   */
  @ApiModelProperty(value = "调整类型")
  private Integer adjustType;

  /**
   * 冗余字段：业务来源编码
   */
  @ApiModelProperty(value = "冗余字段：业务来源编码")
  private String resourceCode;

  /**
   * 调整金额
   */
  @ApiModelProperty(value = "调整金额")
  private BigDecimal adjustFee = BigDecimal.ZERO;

  /**
   * 冗余字段:冻结金额
   */
  @ApiModelProperty(value = "冻结金额")
  private BigDecimal adjustFrozenFee = BigDecimal.ZERO;

  /**
   * 冗余字段：支付类型名称
   */
  @ApiModelProperty(value = "支付类型名称")
  private String payTypeName;

  /**
   * 冗余字段：调整原因
   */
  @ApiModelProperty(value = "冗余字段：调整原因")
  private String adjustReason;

  /**
   * 上账原因
   */
  @ApiModelProperty(value = "冗余字段：上账原因")
  private String onAccountReason;
  /**
   * 冗余字段：冻结明细编码
   */
  private String frozenItemCode;

}
