package com.biz.crm.nebular.sfa.visitstep.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

/**
 * 拜访步骤(离店) 请求vo
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitStepOutStoreReqVo", description = "拜访步骤(离店) ")
public class SfaVisitStepOutStoreReqVo extends CrmExtVo {

    @NotNull(message="拜访计划编码不能为空")
    @ApiModelProperty("拜访编码 关联拜访计划")
    private String visitId;

    @NotNull(message="离店时间不能为空")
    @ApiModelProperty("离店时间")
    private String outTime;

    @NotNull(message="离店地址不能为空")
    @ApiModelProperty("离店地址")
    private String outAddress;

}