package com.biz.crm.nebular.sfa.visitstep.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.sfa.picture.req.SfaVisitPictureReqVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 陈列执行 请求vo
 *
 * @Author Tao.Chen
 * @Date 2020/10/21 15:49
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "陈列执行")
@SaturnEntity(name = "SfaVisitStepDisplayReqVo", description = "陈列执行")
public class SfaVisitStepDisplayReqVo extends CrmExtVo {

    @ApiModelProperty("拜访id")
    @SaturnColumn(description = "拜访id")
    @NotNull(message = "拜访id不能为空")
    private String visitId;

    @ApiModelProperty("陈列执行图片列表")
    @SaturnColumn(description = "陈列执行图片列表")
    private List<SfaVisitPictureReqVo> pictureList;

}