package com.biz.crm.nebular.tpm.act.req;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @Project crm
 * @PackageName com.biz.crm.nebular.tpm.act.req
 * @ClassName TpmActSendMessageVo
 * @Author HuangLong
 * @Date 2021/1/4 14:40
 * @Description tpm活动审批通过和活动关闭推送消息的vo
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TpmActSendMessageVo implements Serializable {
    private static final long serialVersionUID = 7947958952854697771L;

    /**
     * 活动id(调用查询接口com.biz.crm.tpm.act.TpmActFeign#query(java.lang.String))
     */
    private String actId;

    /**
     * 状态类型,直接取枚举ActApproveStatusEnum来判断(approved-审批通过,closed-活动关闭)
     */
    private String approveStatus;
}
