package com.biz.crm.nebular.tpm.act.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动费用分摊表;返回vo
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动费用分摊表;")
@CrmColumnResolve
@SaturnEntity(name = "TmpActFeeShareRespVo", description = "活动费用分摊表;")
public class TmpActFeeShareRespVo extends CrmExtVo {
    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

    @ApiModelProperty("活动明细编码")
    private String actDetailCode;

    @ApiModelProperty("分摊类型(产品分摊,费用分摊)")
    @SaturnColumn(description = "分摊类型(产品分摊,费用分摊)")
    private String shareType;

    @ApiModelProperty("费用所属年月(2020-08)")
    @SaturnColumn(description = "费用所属年月(2020-08)")
    private String feeDateStr;

    @ApiModelProperty("产品编码/产品层级编码")
    @SaturnColumn(description = "产品编码/产品层级编码")
    private String productAndLevelCode;

    @ApiModelProperty("产品名称/产品层级编码")
    @SaturnColumn(description = "产品名称/产品层级编码")
    private String productAndLevelName;

    @ApiModelProperty("产品分摊类型(产品,产品层级)")
    @SaturnColumn(description = "产品分摊类型(产品,产品层级)")
    private String productShareType;

    @ApiModelProperty("分摊金额")
    @SaturnColumn(description = "分摊金额")
    private BigDecimal shareAmount;

    @ApiModelProperty("分摊比例")
    @SaturnColumn(description = "分摊比例")
    private BigDecimal shareRatio;

    @ApiModelProperty("临时字段唯一值")
    @SaturnColumn(description = "临时字段唯一值")
    private String tempUuid;

}