package com.biz.crm.nebular.mdm.position.req;

import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmPositionUnderlingParentSelectReqVo", description = "下属职位选择上级职位请求VO")
public class MdmPositionUnderlingParentSelectReqVo extends PageVo {

    @ApiModelProperty("下级职位编码集合，排除这些职位的下级职位的组织的下级组织的职位")
    private List<String> excludeChildPositionCodeList;

    @ApiModelProperty("职位编码（模糊查询）")
    private String positionCode;

    @ApiModelProperty("组织编码（模糊查询）")
    private String orgCode;

    @ApiModelProperty("职位级别编码（模糊查询）")
    private String positionLevelCode;

    @ApiModelProperty("用户登录名（模糊查询）")
    private String userName;

    @ApiModelProperty("用户编码（模糊查询）")
    private String userCode;

    @ApiModelProperty("用户姓名（模糊查询用户名）")
    private String fullName;

    @ApiModelProperty("职位名称（模糊查询职位名称）")
    private String positionName;

    @ApiModelProperty("组织名称（模糊查询组织名称）")
    private String orgName;

    @ApiModelProperty("是否主职位 0否 1是 （精确查询）")
    private String primaryFlag;

    @ApiModelProperty("启用状态")
    private String enableStatus;

    @ApiModelProperty("上级职位编码（精确查询这个职位编码直接关联的职位）")
    private String parentCode;

}
