package com.biz.crm.nebular.sfa.visitstepdetail.resp;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 拜访步骤(库存盘点);返回vo
 *
 * @author lf
 * @date 2020-12-29 11:35:55
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "拜访步骤(库存盘点);")
@SaturnEntity(name = "SfaVisitStepStockInventoryRespVo", description = "拜访步骤(库存盘点);")
public class SfaVisitStepStockInventoryRespVo extends CrmExtTenVo {
    @ApiModelProperty("拜访id")
    @SaturnColumn(description = "拜访id")
    private String visitDetailId;

    @ApiModelProperty("网点id")
    @SaturnColumn(description = "网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    @SaturnColumn(description = "网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    @SaturnColumn(description = "网点名称")
    private String clientName;

    @ApiModelProperty("网点类型")
    @SaturnColumn(description = "网点类型")
    private String clientType;

    @ApiModelProperty("产品编码")
    @SaturnColumn(description = "产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    @SaturnColumn(description = "产品名称")
    private String productName;

    @ApiModelProperty("数量")
    @SaturnColumn(description = "数量")
    private BigDecimal quantity;

    @ApiModelProperty("单位")
    @SaturnColumn(description = "单位")
    private String unit;

    @ApiModelProperty("人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    private String realName;

    @ApiModelProperty("职位编码")
    private String posCode;

    @ApiModelProperty("职位名称")
    private String posName;

    @ApiModelProperty("组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

}