package com.biz.crm.nebular.log;

import com.biz.crm.nebular.mdm.PageVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/12/17 17:27
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "日志主信息的vo")
@SaturnEntity(name = "CrmLogVo", description = "日志主信息")
@SaturnDomain(value = "crmlog")
public class CrmLogVo extends PageVo {

    @ApiModelProperty(value = "操作类型Code")
    private Integer operationType;

    @ApiModelProperty(value = "记录唯一键（一般是id）(一般只有update操作才有)")
    private String onlyKey;

    @ApiModelProperty(value = "记录唯一描述（用于搜索,新增或者删除用）")
    private String onlyKeyDes;

    @ApiModelProperty(value = "模块编码（取值字典）")
    private String modularCode;

    @ApiModelProperty(value = "更新之前的对象(update和del专属)")
    private Object oldObject;

    @ApiModelProperty(value = "更新之后的对象(update和add专属)")
    private Object newObject;

    @ApiModelProperty(value = "更新之后对比的结果(update专属)")
    private Object compareResult;

    @ApiModelProperty(value = "操作人id")
    private String operationUserId;

    @ApiModelProperty(value = "操作人姓名")
    private String operationUserName;

    @ApiModelProperty(value = "操作时间")
    private String operationTime;

    @ApiModelProperty(value = "操作时间毫秒数")
    private Long operationTimeNum;

}
