package com.biz.crm.nebular.mdm.user.resp;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 用户下拉框返回VO
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "用户下拉框返回VO")
@CrmColumnResolve
public class MdmUserSelectRespVo extends CrmExtTenVo {

    @ApiModelProperty("用户账号登录信息")
    private String userName;

    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("用户类型")
    private String userType;

    @ApiModelProperty("性别")
    private String gender;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("人员姓名")
    private String fullName;

    @ApiModelProperty("生效时间")
    private String endTime;

    @ApiModelProperty("失效时间")
    private String startTime;

    @ApiModelProperty("邮箱")
    private String email;

    @ApiModelProperty("锁定状态 003/009")
    private String lockState;

    @ApiModelProperty("最后一次登录时间")
    private String lastLoginTime;

    @ApiModelProperty("企业用户冗余关联的职位编码集合（英文逗号间隔）")
    private String positionCodeRedundancy;

    @ApiModelProperty("企业用户冗余关联的职位名称集合（英文逗号间隔）")
    private String positionNameRedundancy;

    @ApiModelProperty("用户头像url")
    private String userHeadUrl;

}