package com.biz.crm.nebular.tpm.feebudget.req;
import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.List;
import java.util.Date;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
 * 费用预算明细 请求vo
 *
 * @author huanglong
 * @date 2020-09-16 10:42:32
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "TpmFeeBudgetDetailsReqVo", description = "费用预算明细 ")
public class TpmFeeBudgetDetailsReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("费用预算编码")
    private String feeBudgetCode;

    @ApiModelProperty("费用预算类型(字典)")
    private String feeBudgetType;

    @ApiModelProperty("组织类型")
    private String orgType;

    @ApiModelProperty("预算扣减顺序")
    private Integer reduceOrder;

    @ApiModelProperty("预算扣减比例")
    private BigDecimal reduceRatio;

    @ApiModelProperty("业务单据编码")
    private String businessCode;

    @ApiModelProperty("业务单据名称")
    private String businessName;

    @ApiModelProperty("业务单据明细编码")
    private String businessLineCode;

    @ApiModelProperty("业务备注")
    private String businessRemarks;

    @ApiModelProperty("费用预算明细类型(字典)")
    private String feeBudgetDetailType;

    @ApiModelProperty("费用预算明细类型名称")
    private String feeBudgetDetailTypeName;

    @ApiModelProperty("年份(明细产生的年份)")
    private String year;

    @ApiModelProperty("月份(明细产生的月份)")
    private String month;

    @ApiModelProperty("预算科目编码")
    private String budgetSubjectsCode;

    @ApiModelProperty("预算科目名称")
    private String budgetSubjectsName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("客户所属组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户所属组织名称")
    private String customerOrgName;

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    @ApiModelProperty("渠道编码")
    private String channel;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("门店编码")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    private String terminalName;

    @ApiModelProperty("企业组织编码")
    private String orgCode;

    @ApiModelProperty("企业组织名称")
    private String orgName;

    @ApiModelProperty("期初金额")
    private BigDecimal initAmount;

    @ApiModelProperty("金额;当前操作金额")
    private BigDecimal feeAmount;

    @ApiModelProperty("操作前余额;当前余额")
    private BigDecimal beforAmount;

    @ApiModelProperty("操作后余额")
    private BigDecimal afterAmount;

}