package com.biz.crm.nebular.activiti.act.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * @author weston
 * @date 2020-12-23
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "RejectToHisTaskReqVO", description = "回退某历史节点请求VO")
@AllArgsConstructor
@NoArgsConstructor
public class RejectToHisTaskReqVO {

    @ApiModelProperty(value = "节点ID", required = true)
    private String taskId;

    @ApiModelProperty(value = "目标节点定义KEY", required = true)
    private String taskDefKey;

    @ApiModelProperty(value = "备注", required = true)
    private String remark;
}
