package com.biz.crm.nebular.mdm.position.resp;

import com.biz.crm.nebular.mdm.CrmTreeTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 职位表返回vo
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "职位下拉框或列表查询")
public class MdmPositionSelectRespVo extends CrmTreeTenVo {

    @ApiModelProperty("职位编码")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("关联组织编码")
    private String orgCode;

    @ApiModelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("上级职位编码")
    private String parentCode;

    @ApiModelProperty("上级职位名称")
    private String parentName;

    @ApiModelProperty("职位级别编码")
    private String positionLevelCode;

    @ApiModelProperty("职位级别名称")
    private String positionLevelName;

    @ApiModelProperty("是否主职位1是0否")
    private String primaryFlag;

    @ApiModelProperty("是否当前职位1是0否")
    private String currentFlag;

    @ApiModelProperty("用户登录名")
    private String userName;

    @ApiModelProperty("用户姓名")
    private String fullName;

    @ApiModelProperty("用户编码")
    private String userCode;

    @ApiModelProperty("上级用户编码")
    private String parentUserName;

    @ApiModelProperty("上级用户名称")
    private String parentFullName;

    @ApiModelProperty("上级用户编码")
    private String parentUserCode;

    @ApiModelProperty("组织名称/职位名称/用户名称")
    private String unionName;

    @ApiModelProperty("电话")
    private String userPhone;

    @ApiModelProperty("职位冗余全部关联角色编码集合，英文逗号间隔")
    @Deprecated
    private String roleCodeRedundancy;

    @ApiModelProperty("职位冗余全部关联角色名称集合，英文逗号间隔")
    @Deprecated
    private String roleNameRedundancy;

    @ApiModelProperty("用户头像url")
    private String userHeadUrl;

}