package com.biz.crm.nebular.sfa.assistant.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.assistant.resp.SfaWorkTaskPictureRespVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 工作任务(发布) 返回vo
 *
 * @author liuhongming
 * @date 2020-10-14 19:54:03
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "工作任务报表 ")
public class SfaWorkTaskReportReqVo extends CrmExtTenVo {

    @ApiModelProperty("任务id")
    private String taskId;

    @ApiModelProperty("任务编码")
    private String taskCode;

    @ApiModelProperty("任务标题")
    private String taskTitle;

    @ApiModelProperty("发布时间")
    private String releaseDate;

    @ApiModelProperty("发布开始时间")
    private String releaseStartDate;

    @ApiModelProperty("发布结束时间")
    private String releaseEndDate;

    @ApiModelProperty("开始时间")
    private String startDate;

    @ApiModelProperty("截至时间")
    private String endDate;

    @ApiModelProperty("任务详情")
    private String content;

    @ApiModelProperty("任务发送人")
    private String senderName;

    @ApiModelProperty("任务地点")
    private String taskSite;

    @ApiModelProperty("任务进度 100以内数字 省略%")
    private String progress;

    @ApiModelProperty("执行状态 0待执行 1已完成 2已回绝 3已过期")
    private String executeStatus;

    @ApiModelProperty("任务接收人")
    private String receverName;

    @ApiModelProperty("接收人账号")
    private String receverCode;

    @ApiModelProperty("任务执行时间")
    private String receveDate;

    @ApiModelProperty("任务执行开始时间")
    private String receveStartDate;

    @ApiModelProperty("任务执行结束时间")
    private String receveEndDate;

    @ApiModelProperty("执行是定位地址")
    private String address;

    @ApiModelProperty("任务接收总结")
    private String summary;

    @ApiModelProperty("执行人组织编码")
    private String receverOrgCode;

    @ApiModelProperty("执行人组织名称")
    private String receverOrgName;

    @ApiModelProperty("执行人职位编码")
    private String receverPosCode;

    @ApiModelProperty("执行人职位名称")
    private String receverPosName;

    @ApiModelProperty("任务照片列表")
    private List<SfaWorkTaskPictureRespVo> pictures;

    @ApiModelProperty("组织编码集合")
    private List<String> orgCodeList;




}