package com.biz.crm.nebular.tpm.audit.resp;
import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 核销申请活动表 返回vo
 *
 * @author huanglong
 * @date 2020-10-09 14:05:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "核销申请活动表 ")
@CrmColumnResolve
@SaturnEntity(name = "TpmAuditActRespVo", description = "核销申请活动表 ")
public class TpmAuditActRespVo extends CrmExtVo {
    @ApiModelProperty("核销申请编码")
    @SaturnColumn(description = "核销申请编码")
    private String auditCode;

    @ApiModelProperty("活动编码")
    @SaturnColumn(description = "活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    @SaturnColumn(description = "活动名称")
    private String actName;

    @ApiModelProperty("开始日期")
    @SaturnColumn(description = "开始日期")
    private String beginDate;

    @ApiModelProperty("开始时间")
    @SaturnColumn(description = "开始时间")
    private String beginDateSecond;

    @ApiModelProperty("结束日期")
    @SaturnColumn(description = "结束日期")
    private String endDate;

    @ApiModelProperty("结束时间")
    @SaturnColumn(description = "结束时间")
    private String endDateSecond;

    @ApiModelProperty("临时字段唯一值")
    @SaturnColumn(description = "临时字段唯一值")
    private String tempUuid;

    @ApiModelProperty("申请人")
    @SaturnColumn(description = "申请人")
    private String actCreateUser;

    @ApiModelProperty("活动类型")
    private String actType;

    @ApiModelProperty("活动id")
    private String actId;

}