package com.biz.crm.nebular.sfa.acttask.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.sfa.acttask.req.SfaActRangeReqVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 活动任务管理 返回vo
 *
 * @author liuhongming
 * @date 2020-09-23 11:24:25
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动任务管理 ")
@SaturnEntity(name = "SfaActTaskRespVo", description = "活动任务管理 ")
public class SfaActTaskRespVo extends CrmExtVo {
    @ApiModelProperty("活动编码 活动编码")
    @SaturnColumn(description = "活动编码 活动编码")
    private String actCode;

    @ApiModelProperty("活动名称 活动名称")
    @SaturnColumn(description = "活动名称 活动名称")
    private String actName;

    @ApiModelProperty("活动类型 活动类型(display:陈列活动，cost:费用活动)")
    @SaturnColumn(description = "活动类型 活动类型(display:陈列活动，cost:费用活动)")
    private String actType;

    @ApiModelProperty("活动开始时间 活动开始时间")
    @SaturnColumn(description = "活动开始时间 活动开始时间")
    private String beginDate;

    @ApiModelProperty("活动结束时间 活动结束时间")
    @SaturnColumn(description = "活动结束时间 活动结束时间")
    private String endDate;

    @ApiModelProperty("活动描述 活动描述")
    @SaturnColumn(description = "活动描述 活动描述")
    private String actDesc;

    @ApiModelProperty("预估销售额 费用活动-预估销售额")
    @SaturnColumn(description = "预估销售额 费用活动-预估销售额")
    private BigDecimal forecastSalesAmount;

    @ApiModelProperty("费用申请金额 费用活动-费用申请金额")
    @SaturnColumn(description = "费用申请金额 费用活动-费用申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("活动要求 活动要求")
    @SaturnColumn(description = "活动要求 活动要求")
    private String actRequire;

    @ApiModelProperty("任务执行频率 陈列活动-任务执行频率")
    @SaturnColumn(description = "任务执行频率 陈列活动-任务执行频率")
    private BigDecimal actFrequency;


    @ApiModelProperty("活动范围 活动范围包含")
    @SaturnColumn(description = "活动范围 活动范围包含")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaActRangeRespVo> sfaActRangeRespContainVos;

    @ApiModelProperty("活动范围 活动范围不包含")
    @SaturnColumn(description = "活动范围 活动范围不包含")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaActRangeRespVo> sfaActRangeRespNotContainVos;

    @ApiModelProperty("陈列要求 陈列活动-陈列要求")
    @SaturnColumn(description = "陈列要求 陈列活动-陈列要求")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaActProductRespVo> sfaActProductRespVos;
    @ApiModelProperty("示例图片 陈列活动-活动附件示例图片")
    @SaturnColumn(description = "示例图片 陈列活动-活动附件示例图片")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<SfaActFileRespVo> sfaActFileRespVos;

}