package com.biz.crm.nebular.sfa.visitstep.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 活动执行;返回vo
 *
 * @author lf
 * @date 2020-12-30 19:45:12
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "活动执行;")
@SaturnEntity(name = "SfaVisitStepActivityExecutionRespVo", description = "活动执行;")
public class SfaVisitStepActivityExecutionRespVo extends CrmExtTenVo {
    @ApiModelProperty("拜访id")
    @SaturnColumn(description = "拜访id")
    private String visitId;

    @ApiModelProperty("活动执行类型(0-费用活动,1-陈列活动)")
    @SaturnColumn(description = "活动执行类型(0-费用活动,1-陈列活动)")
    private String activityType;

    @ApiModelProperty("网点id")
    @SaturnColumn(description = "网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    @SaturnColumn(description = "网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    @SaturnColumn(description = "网点名称")
    private String clientName;

    @ApiModelProperty("客户类型(dealer-经销商,terminal-终端,batchDealer-二批商)")
    @SaturnColumn(description = "客户类型(dealer-经销商,terminal-终端,batchDealer-二批商)")
    private String clientType;

    @ApiModelProperty("活动执行时间")
    @SaturnColumn(description = "活动执行时间")
    private String activityTime;

    @ApiModelProperty("人员账号")
    @SaturnColumn(description = "人员账号")
    private String userName;

    @ApiModelProperty("人员姓名")
    @SaturnColumn(description = "人员姓名")
    private String realName;

    @ApiModelProperty("职位名称")
    @SaturnColumn(description = "职位名称")
    private String posName;

    @ApiModelProperty("职位编码")
    @SaturnColumn(description = "职位编码")
    private String posCode;

    @ApiModelProperty("组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

}