package com.biz.crm.nebular.sfa.worksign.resp;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import com.biz.crm.nebular.sfa.worksign.req.SfaApplyTimeInfoReqVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author ren.gang
 * @ClassName SfaLeaveCancelRespVo.java
 * @Description 销假返回信息
 * @createTime 2020年12月09日 22:32:00
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "销假信息返回Vo")
@SaturnEntity(name = "SfaLeaveCancelRespVo", description = "销假信息返回Vo")
public class SfaLeaveCancelRespVo {

    @ApiModelProperty("请假id")
    private String leaveId;

    @ApiModelProperty("销假开始时间")
    private String beginTime;

    @ApiModelProperty("销假结束时间")
    private String endTime;

    @ApiModelProperty("销假天数")
    private String cancelDays;

    @ApiModelProperty("销假日期明细")
    private String timeInfoListJson;

    @ApiModelProperty(value = "日期明细列表")
    private List<SfaApplyTimeInfoReqVo> timeInfoList;

}
