package com.biz.crm.nebular.activiti.task.resp;

import com.biz.crm.nebular.activiti.act.resp.TaActFileRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * @author weston
 * @date 2020-11-25
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "任务节点响应vo")
@SaturnEntity(name = "TaskRspVO", description = "任务节点响应vo")
public class TaskRspVO {

    @ApiModelProperty(value = "节点ID")
    private String taskId;

    @ApiModelProperty(value = "任务节点定义key")
    private String taskDefKey;

    @ApiModelProperty(value = "任务名称")
    private String taskName;

    @ApiModelProperty(value = "任务节点生成时间")
    private Date taskCreateTime;

    @ApiModelProperty(value = "任务节点处理时间")
    private Date taskDoneTime;

    @ApiModelProperty(value = "流程名称")
    private String processName;

    @ApiModelProperty(value = "表单编号")
    private String formNo;

    @ApiModelProperty(value = "表单标题")
    private String formTitle;

    @ApiModelProperty(value = "表单业务类型")
    private String costType;

    @ApiModelProperty(value = "表单来源系统")
    private String formType;

    @ApiModelProperty(value = "业务编码")
    private String businessCode;

    @ApiModelProperty(value = "流程实例ID")
    private String processInstanceId;

    @ApiModelProperty(value = "流程状态:0=草稿1=审批中2=已完成3=驳回4=终止5=撤销")
    private Integer processState;

    @ApiModelProperty(value = "流程状态描述")
    private String processStateDesc;

    @ApiModelProperty("发起人账号")
    private String startUserCode;

    @ApiModelProperty(value = "发起人姓名")
    private String startUserName;

    @ApiModelProperty(value = "发起人岗位编码")
    private String startPosCode;

    @ApiModelProperty(value = "发起人岗位名称")
    private String startPosName;

    @ApiModelProperty(value = "发起时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date createTime;

    @ApiModelProperty(value = "流程key")
    private String processKey;

    @ApiModelProperty(value = "处理备注")
    private String content;

    @ApiModelProperty("节点处理人账号")
    private String currentCode;

    @ApiModelProperty(value = "节点处理人姓名")
    private String currentName;

    @ApiModelProperty(value = "节点处理人岗位编码")
    private String currentPosCode;

    @ApiModelProperty(value = "节点处理人岗位名称")
    private String currentPosName;

    @ApiModelProperty(value = "待处理岗位名称")
    private String pendingPostName;

    @ApiModelProperty(value = "待处理人员名称")
    private String pendingUserName;

    @ApiModelProperty(value = "待处理岗位Code")
    private String pendingPostCode;

    @ApiModelProperty(value = "待处理人员名称Code")
    private String pendingUserCode;
    @ApiModelProperty(value = "流程编号")
    private String processNo;


    @ApiModelProperty(value = "任务类型：普通-代理")
    private String taskType;

    @ApiModelProperty(value = "任务处理文件")
    private List<TaActFileRespVo> fileList;
}
