package com.biz.crm.nebular.mdm.cusorg;

import com.biz.crm.common.ParamCheck;
import com.biz.crm.nebular.mdm.enums.ParamCheckTypeEnum;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zxw
 */
@NebulaExcelImport(startRow = 1)
public class CusOrgImportExcelVo implements Serializable {

    @NebulaExcelColumn(order = 0, title = "客户组织名称")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.LENGTH}, msg = "客户组织名称不能为空", length = 128)
    private String name;

    @NebulaExcelColumn(order = 1, title = "客户组织层级")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.DICT}, msg = "客户组织层级不能为空", dictType = "cus_org_level")
    private String level;

    @NebulaExcelColumn(order = 2, title = "客户组织类型")
    @ParamCheck(isNotNull = true, checkType = {ParamCheckTypeEnum.DICT}, msg = "客户组织类型不能为空", dictType = "cus_org_type")
    private String type;

    @NebulaExcelColumn(order = 3, title = "上级客户组织编码")
    @ParamCheck(isNotNull = false)
    private String parentCode;

    @NebulaExcelColumn(order = 4, title = "客户组织描述")
    @ParamCheck(isNotNull = false, checkType = {ParamCheckTypeEnum.LENGTH}, length = 50)
    private String decript;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLevel() {
        return level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getParentCode() {
        return parentCode;
    }

    public void setParentCode(String parentCode) {
        this.parentCode = parentCode;
    }

    public String getDecript() {
        return decript;
    }

    public void setDecript(String decript) {
        this.decript = decript;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        return "CusOrgImportExcelVo{" +
            ", name='" + name + '\'' +
            ", level='" + level + '\'' +
            ", parentCode='" + parentCode + '\'' +
            ", decript='" + decript + '\'' +
            ", type='" + type + '\'' +
            '}';
    }
}
