package com.biz.crm.nebular.rebate.rebatedetail;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 返利明细vo
 * @Author: chenrong
 * @Date: 2021/1/12 10:26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "返利明细vo")
@SaturnEntity(name = "RebateDetailVo", description = "返利明细信息")
@SaturnDomain(value = "RebateDetailVo")
public class RebateDetailVo extends CrmExtVo {

  private static final long serialVersionUID = 5604890895044433041L;

  /**
   * 编码
   */
  @ApiModelProperty(value = "编码")
  private String code;
  /**
   * 名称
   */
  @ApiModelProperty(value = "名称")
  private String name;
  /**
   * 上账状态
   */
  @ApiModelProperty(value = "上账状态")
  private Integer onAccountState;
  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String cusCode;
  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String cusName;
  /**
   * 渠道编码
   */
  @ApiModelProperty(value = "渠道编码")
  private String cusChannelCode;
  /**
   * 渠道名称
   */
  @ApiModelProperty(value = "渠道名称")
  private String cusChannelName;
  /**
   * 客户所属组织编码
   */
  @ApiModelProperty(value = "客户所属组织编码")
  private String cusOrgCode;
  /**
   * 客户所属组织名称
   */
  @ApiModelProperty(value = "客户所属组织名称")
  private String cusOrgName;
  /**
   * 返利量
   */
  @ApiModelProperty(value = "返利量")
  private BigDecimal computeAmount = BigDecimal.ZERO;
  /**
   * 调整量
   */
  @ApiModelProperty(value = "调整量")
  private BigDecimal adjustAmount = BigDecimal.ZERO;
  /**
   * 实际返利量
   */
  @ApiModelProperty(value = "实际返利量")
  private BigDecimal actualAmount = BigDecimal.ZERO;
  /**
   * 返利类型
   */
  @ApiModelProperty(value = "返利类型")
  private Integer rebateType;
  /**
   * 政策开始时间
   */
  @ApiModelProperty(value = "政策开始时间")
  private String startTime;
  /**
   * 政策结束时间
   */
  @ApiModelProperty(value = "政策结束时间")
  private String endTime;
  /**
   * 计算年月
   */
  @ApiModelProperty(value = "计算年月")
  private String computeYearMonth;
  /**
   * 计算时间
   */
  @ApiModelProperty(value = "计算时间")
  private String computeTime;
}
