package com.biz.crm.nebular.activiti.task.req;

import com.biz.crm.nebular.activiti.act.resp.TaProxyProcessReqVo;
import com.biz.crm.nebular.mdm.PageVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jdk.internal.dynalink.linker.LinkerServices;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * @author weston
 * @date 2020-11-25
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "TaskQueryReqVO", description = "任务节点查询请求VO")
@AllArgsConstructor
@NoArgsConstructor
public class TaskQueryReqVO extends PageVo {

    @ApiModelProperty(value = "用户编码", required = true)
    private String userCode;

    @ApiModelProperty(value = "用户岗位编码")
    private String positionCode;

    @ApiModelProperty(value = "标题,模糊查询")
    private String title;

    @ApiModelProperty(value = "表单业务类型")
    private String costType;

    @ApiModelProperty(value = "表单来源业务系统")
    private String formType;

    @ApiModelProperty("表单类型二级编码")
    private String smallType;

    @ApiModelProperty("状态编码,2-审批中，4-驳回")
    private String status;

    @ApiModelProperty("流程名称")
    private String processName;

    @ApiModelProperty("表单编号")
    private String formNo;

    @ApiModelProperty("表单名称")
    private String formTitle;

    @ApiModelProperty("业务编码")
    private String businessCode;

    @ApiModelProperty("发起者姓名")
    private String startUserName;

    @ApiModelProperty("岗位编码列表")
    private List<String> positionCodes;

    /**
     * 代理审批流程
     */
    private List<TaProxyProcessReqVo> proxyProcessReqVos;
}
