package com.biz.crm.nebular.activiti.task.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * @author weston
 * @date 2020-11-26
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "流程审批记录响应vo")
@SaturnEntity(name = "OptRecordRspVO", description = "流程审批记录响应vo")
public class OptRecordRspVO {

    @ApiModelProperty(value = "审批记录ID")
    private String id;

    @ApiModelProperty(value = "审批时间")
    private Date createTime;

    @ApiModelProperty(value = "审批人编码")
    private String userCode;

    @ApiModelProperty(value = "审批人名称")
    private String userName;

    @ApiModelProperty(value = "审批人岗位编码")
    private String positionCode;

    @ApiModelProperty(value = "审批人岗位名称")
    private String positionName;

    @ApiModelProperty(value = "审批人操作备注")
    private String content;

    @ApiModelProperty(value = "流程名称")
    private String processName;

    @ApiModelProperty(value = "节点名称")
    private String taskName;

    @ApiModelProperty(value = "节点实例ID")
    private String taskId;

    @ApiModelProperty(value = "操作按钮描述")
    private String operationStr;

    @ApiModelProperty(value = "操作按钮")
    private String operation;

    @ApiModelProperty(value = "标题")
    private String title;

    @ApiModelProperty(value = "发起人名称")
    private String applierName;

    @ApiModelProperty(value = "流程实例ID")
    private String processInstId;

    @ApiModelProperty(value = "流程节点定义KEY")
    private String taskDefKey;

    @ApiModelProperty(value = "流程定义KEY")
    private String processKey;

    @ApiModelProperty(value = "表单单号")
    private String formNo;

    @ApiModelProperty("流程版本号")
    private String processVersionKey;

}
