package com.biz.crm.nebular.activiti.act.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Map;

/**
 * @author weston
 * @date 2020-12-08
 */
@Data
@Builder
@Accessors(chain = true)
@ApiModel(value = "StartProcessReqVo", description = "创建一个流程请求VO")
@AllArgsConstructor
@NoArgsConstructor
public class StartProcessReqVo {

    @ApiModelProperty(value = "用户编码", required = true)
    private String userCode;

    @ApiModelProperty(value = "岗位编码", required = true)
    private String posCode;

    @ApiModelProperty(value = "流程key", required = true)
    private String processKey;

    @ApiModelProperty(value = "业务单号", required = true)
    private String formNo;

    @ApiModelProperty(value = "业务编号code", required = true)
    private String businessCode;

    @ApiModelProperty(value = "表单标题", required = true)
    private String title;

    @ApiModelProperty(value = "表单URL", required = true)
    private String formUrl;

    @ApiModelProperty(value = "发起时的备注", required = false)
    private String remark;

    @ApiModelProperty(value = "防重复签名验证码")
    private String signTicket;

    @ApiModelProperty(value = "回调方法的feign", required = true)
    private String callBackFeign;

    @ApiModelProperty(value = "业务流程类型")
    private String costType;

    @ApiModelProperty(value = "业务来源系统")
    private String formType;

    @ApiModelProperty(value = "业务流程细类")
    private String smallType;

    @ApiModelProperty(value = "发起流程的按钮，非必填")
    private String optBtn;

    @ApiModelProperty(value = "业务参数(键值对,可选参数)")
    private Map<String, Object> variables;

}
