package com.biz.crm.nebular.rebate.product;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Description
 * @Author lxx
 * @Date 2021/1/7 16:04
 * @Version 1.0
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "返利商品vo")
public class RebateProductVo extends CrmExtVo {

    @ApiModelProperty(value = "返利编码")
    private String rebateCode;

    @ApiModelProperty(value = "产品名称")
    private String productName;

    @ApiModelProperty(value = "产品编码")
    private String productCode;

    @ApiModelProperty(value = "产品层级名称")
    private String productLevelName;

    @ApiModelProperty(value = "产品层级编码")
    private String productLevelCode;

    @ApiModelProperty(value = "系数")
    private BigDecimal coeff;

    @ApiModelProperty(value = "是否产品层级")
    private Integer productLevelFlag;

    @ApiModelProperty(value = "是否考核产品")
    private Integer assessFlag;
}
