package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.config.CrmColumnResolve;
import com.biz.crm.config.CrmDict;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 返回vo
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "客户信息")
@SaturnDomain(value = "mdmcustomermsgrespvo")
@SaturnEntity(name = "MdmCustomerMsgRespVo", description = "客户信息")
@CrmColumnResolve
public class MdmCustomerMsgRespVo extends CrmTreeVo {

    @ApiModelProperty("渠道")
    @SaturnColumn(description = "渠道")
    private String channel;

    @ApiModelProperty("渠道")
    @SaturnColumn(description = "渠道名称")
    @CrmDict(typeCode = "channel", dictCodeField = "channel")
    private String channelName;

    @ApiModelProperty("客户编码")
    @SaturnColumn(description = "客户编码")
    private String customerCode;

    @ApiModelProperty("客户组织编码")
    @SaturnColumn(description = "客户组织编码")
    private String customerOrgCode;

    @ApiModelProperty("客户名称")
    @SaturnColumn(description = "客户名称")
    private String customerName;

    @ApiModelProperty("客户组织")
    @SaturnColumn(description = "客户组织")
    private String customerOrgName;

    @ApiModelProperty("客户类型")
    @SaturnColumn(description = "客户类型")
    private String customerType;

    @ApiModelProperty("客户类型")
    @SaturnColumn(description = "客户类型名称")
    @CrmDict(typeCode = "customer_type", dictCodeField = "customerType")
    private String customerTypeName;

    @ApiModelProperty("操作类型")
    @SaturnColumn(description = "操作类型")
    private String operateType;

    @ApiModelProperty("组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty("所属组织名称")
    @SaturnColumn(description = "所属组织名称")
    private String orgName;

    @ApiModelProperty("市")
    @SaturnColumn(description = "市")
    private String cityCode;

    @ApiModelProperty("区")
    @SaturnColumn(description = "区")
    private String districtCode;

    @ApiModelProperty("省")
    @SaturnColumn(description = "省")
    private String provinceCode;

    @ApiModelProperty("市名称")
    @SaturnColumn(description = "市")
    private String cityName;

    @ApiModelProperty("区名称")
    @SaturnColumn(description = "区")
    private String districtName;

    @ApiModelProperty("省名称")
    @SaturnColumn(description = "省")
    private String provinceName;

    @ApiModelProperty("注册地址")
    @SaturnColumn(description = "注册地址")
    private String registeredAddress;

    @ApiModelProperty("工程名")
    @SaturnColumn(description = "工程名")
    private String projectName;

    @ApiModelProperty("客户联系方式")
    @SaturnColumn(description = "客户联系方式")
    private String customerContact;

    @ApiModelProperty("客户法人代表")
    @SaturnColumn(description = "客户法人代表")
    private String legalRepresentative;

    @ApiModelProperty("企业组织类型")
    @SaturnColumn(description = "企业组织类型")
    private Integer orgType;

    @ApiModelProperty("用户帐号")
    @SaturnColumn(description = "用户帐号")
    private String userName;

    @ApiModelProperty("是否是主客户：N否Y是")
    @SaturnColumn(description = "是否是主客户：N否Y是")
    private String customerPrimary;

    @ApiModelProperty("锁定状态：009正常，003冻结")
    @SaturnColumn(description = "锁定状态：009正常，003冻结")
    private String lockState;

    @ApiModelProperty("锁定状态：009正常，003冻结")
    @CrmDict(typeCode = "lock_state",dictCodeField = "lockState")
    private String lockStateName;


    @ApiModelProperty("对接人列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    @SaturnColumn(description = "对接人列表")
    private List<MdmCustomerDockingRespVo> mdmCustomerDockingVos;

    @ApiModelProperty("销售区域列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    @SaturnColumn(description = "销售区域列表")
    private List<MdmCustomerSaleAreaRespVo> mdmCustomerSaleAreaVos;

    @ApiModelProperty("联系人列表")
    @SaturnColumn(description = "联系人列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    private List<MdmCustomerContactRespVo> mdmCustomerContactVos;

    @ApiModelProperty("关联角色编码,多个逗号间隔")
    private String roleCode;
    @ApiModelProperty("关联角色名称,多个逗号间隔")
    private String roleName;

    @ApiModelProperty("经度")
    private String longitude;
    @ApiModelProperty("纬度")
    private String latitude;

    @ApiModelProperty("erp编码")
    private String erpCode;

    @ApiModelProperty("审批状态,枚举ActApproveStatusEnum")
    private String actApproveStatus;

    private List<MdmCustomerTypeVo> mdmCustomerTypeVos;
    private List<MdmCustSaleCompanyVo> mdmCustSaleCompanyVos;
}
