package com.biz.crm.common;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.google.common.collect.Sets;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.Set;


/**
 * excel 导入VO 基类
 *  @author: luoqi
 *  @Date: 2020-12-9 14:29
 *  @version: V1.0
 *  @Description:
 */
public abstract class AbstractImportVo {


    public static final Set<String> BASE_IMPORT_COLUMNS = Sets.newHashSet("rowIndex", "processType", "validateMsg", "saveMsg");

    /**
     *向子类提供忽略父类字段的扩展
     * @return
     */
    public Set<String> superIgnore(){
        return Sets.newHashSet();
    }

    /**
     * 行号
     */
    @Getter
    @ExcelProperty(value = "原Excel行号", order = 10000)
    private Integer rowIndex;

    /**
     * 头占用了一行，所以加一
     * @param rowIndex
     */
    public void setRowIndex(Integer rowIndex) {
        if(null == rowIndex){
            return;
        }
        this.rowIndex = rowIndex + 1;
    }

    /**
     * 处理结果类型 ProcessTypeEnum
     */
    @Getter
    @Setter
    @ExcelProperty(value = "处理结果", order = 10001, converter = ProcessTypeEnumConverter.class)
    private ProcessTypeEnum processType = ProcessTypeEnum.SUCCESS;

    private static final String DEF_MSG = "成功;";
    private static final String FAIL_MSG = "失败;";
    /**
     * 校验结果描述
     */
    @Getter
    @ExcelProperty(value = "校验结果描述", order = 10002)
    private String validateMsg = DEF_MSG;
    /**
     * 保存结果描述
     */
    @Getter
    @ExcelProperty(value = "保存结果描述", order = 10003)
    private String saveMsg = DEF_MSG;


    /**
     * 校验失败结果描述
     * @param msg
     */
    public void appendErrorValidateMsg(String msg){
        this.processType = ProcessTypeEnum.FAIL;
        this.saveMsg = FAIL_MSG;
        if(StringUtils.isBlank(msg)){
            this.validateMsg = FAIL_MSG;
            return;
        }
        if(DEF_MSG.equals(this.validateMsg)){
            this.validateMsg = msg;
            return;
        }
        this.validateMsg += msg;
    }
    /**
     * 保存失败结果描述
     * @param msg
     */
    public void appendErrorSaveMsg(String msg){
        this.processType = ProcessTypeEnum.FAIL;
        if(StringUtils.isBlank(msg)){
            return;
        }
        if(DEF_MSG.equals(this.saveMsg)){
            this.saveMsg = msg;
            return;
        }
        this.saveMsg += msg;
    }



    /**
     * 处理结果类型
     *  @author: luoqi
     *  @Date: 2020-12-10 11:23
     *  @version: V1.0
     *  @Description:
     */
    public enum ProcessTypeEnum{
        /** 成功 */
        SUCCESS("SUCCESS", "成功"),
        /** 失败 */
        FAIL("FAIL", "失败");

        private String value;
        private String des;
        ProcessTypeEnum(String value, String des) {
            this.value = value;
            this.des = des;
        }

        public String getValue() {
            return value;
        }

        public String getDes() {
            return des;
        }
    }

    public static class ProcessTypeEnumConverter implements Converter<ProcessTypeEnum> {

        /**
         * Back to object types in Java
         *
         * @return Support for Java class
         */
        @Override
        public Class supportJavaTypeKey() {
            return ProcessTypeEnum.class;
        }
        /**
         * Back to object enum in excel
         *
         * @return Support for {@link CellDataTypeEnum}
         */
        @Override
        public CellDataTypeEnum supportExcelTypeKey() {
            return CellDataTypeEnum.STRING;
        }
        /**
         * Convert excel objects to Java objects
         *
         * @param cellData            Excel cell data.NotNull.
         * @param contentProperty     Content property.Nullable.
         * @param globalConfiguration Global configuration.NotNull.
         * @return Data to put into a Java object
         * @throws Exception Exception.
         */
        @Override
        public ProcessTypeEnum convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
            String data = cellData.getStringValue();
            if(StringUtils.isBlank(data)){
                return null;
            }
            return ProcessTypeEnum.valueOf(data);
        }

        /**
         * Convert Java objects to excel objects
         *
         * @param value               Java Data.NotNull.
         * @param contentProperty     Content property.Nullable.
         * @param globalConfiguration Global configuration.NotNull.
         * @return Data to put into a Excel
         * @throws Exception Exception.
         */
        @Override
        public CellData convertToExcelData(ProcessTypeEnum value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
            return new CellData(value.getDes());
        }
    }

}
