package com.biz.crm.nebular.rebate.area;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnDomain;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description
 * @Author lxx
 * @Date 2021/1/11 14:19
 * @Version 1.0
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "返利范围vo")
@SaturnEntity(name = "RebateAreaVo", description = "返利范围信息")
@SaturnDomain(value = "RebateAreaVo")
public class RebateAreaVo extends CrmExtVo {

    @ApiModelProperty(value = "返利编码")
    @SaturnColumn(description = "返利编码")
    private String rebateCode;

    @ApiModelProperty(value = "组织名称")
    @SaturnColumn(description = "组织名称")
    private String orgName;

    @ApiModelProperty(value = "组织编码")
    @SaturnColumn(description = "组织编码")
    private String orgCode;

    @ApiModelProperty(value = "客户名称")
    @SaturnColumn(description = "客户名称")
    private String cusName;

    @ApiModelProperty(value = "客户编码")
    @SaturnColumn(description = "客户编码")
    private String cusCode;

    @ApiModelProperty(value = "是否组织")
    @SaturnColumn(description = "是否组织")
    private Integer orgFlag;

    @ApiModelProperty(value = "是否包含")
    @SaturnColumn(description = "是否包含")
    private Integer containFlag;
}
