package com.biz.crm.nebular.dms.rebatefeepool;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 费用折扣汇总报表查询返回结果
 * @Author: chenrong
 * @Date: 2020/12/14 14:07
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "费用折扣汇总报表查询返回结果")
public class RebateFeePoolSumReportRes {

  /**
   * 客户编码
   */
  @ApiModelProperty(value = "客户编码")
  private String cusCode;

  /**
   * 客户名称
   */
  @ApiModelProperty(value = "客户名称")
  private String cusName;

  /**
   * 客户所属组织编码
   */
  @ApiModelProperty(value = "客户所属组织编码")
  private String cusOrgCode;

  /**
   * 客户所属组织名称
   */
  @ApiModelProperty(value = "客户所属组织名称")
  private String cusOrgName;

  /**
   * 销售公司编码
   */
  @ApiModelProperty(value = "销售公司编码")
  private String saleCompanyCode;

  /**
   * 销售公司名称
   */
  @ApiModelProperty(value = "销售公司名称")
  private String saleCompanyName;

  /**
   * 客户所属渠道编码
   */
  @ApiModelProperty(value = "客户所属渠道编码")
  private String cusChannelCode;

  /**
   * 客户所属渠道名称
   */
  @ApiModelProperty(value = "客户所属渠道名称")
  private String cusChannelName;

  /**
   * 可用费用余额
   */
  @ApiModelProperty(value = "可用费用余额")
  private BigDecimal availableBalance;
  /**
   * 上月费用余额
   */
  @ApiModelProperty(value = "上月费用余额")
  private BigDecimal lastBalance;
  /**
   * 本月上账金额
   */
  @ApiModelProperty(value = "本月上账金额")
  private BigDecimal currentOnAccountFee;
  /**
   * 本月已使用金额
   */
  @ApiModelProperty(value = "本月已使用金额")
  private BigDecimal currentUsedFee;

  /**
   * 期间
   */
  @ApiModelProperty("期间")
  private String period;
}
