package com.biz.crm.nebular.mdm.humanarea;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnDefaultController;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * @author zxw
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Accessors(chain = true)
@SaturnEntity(name = "OrgVo", description = "组织树")
public class OrgVo {
    @SaturnColumn(description = "id", nullable = false)
    private String id;
    @SaturnColumn(description="组织机构的唯一编号", length=128, nullable=false,unique = true)
    private String orgCode;
    @SaturnColumn(description = "组织机构名称", length = 64, nullable = false)
    private String orgName;
    @SaturnColumn(description = "组织机构类型(0:部门,1:单位)", nullable = false)
    private Integer orgType;
    @SaturnColumn(description = "组织机构描述", nullable = false, length = 512)
    private String description;
    @SaturnColumn(description = "组织机构排序", nullable = false)
    private Integer orgSortIndex;
    @SaturnColumn(description = "创建时间", nullable = false)
    private Date createTime;
    @ApiModelProperty("层级")
    @SaturnColumn(description = "层级",nullable = false)
    private String orgLevel;
    @SaturnColumn(description = "上级id",nullable = false)
    private String parentId;
    @SaturnColumn(description = "下级组织")
    @SaturnColumnRelation(type= SaturnColumnRelation.RelationType.OneToMany, master=true, mappedBy="orgs")
    private List<OrgVo> children;
    @SaturnColumn(description = "组织机构状态", nullable = false)
    @SaturnDefaultController(defaultType= SaturnDefaultController.Type.SELECT, defaultKeys="正常,不正常", defaultValues="1,0")
    private Integer tstatus;
    @SaturnColumn(description = "是否是叶子节点")
    private Boolean isLeaf;
}
