package com.biz.crm.nebular.rebate.variable;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * @Author: huojia
 * @DateTime: 2021/1/7 11:15
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "返利变量的vo")
public class RebateVariableVo extends CrmExtVo {

    /**
     * 返利变量名称
     */
    @ApiModelProperty(value = "返利变量名称")
    private String name;

    /**
     * 返利变量编码
     */
    @ApiModelProperty(value = "返利变量编码")
    private String code;

    /**
     * bean名称
     */
    @ApiModelProperty(value = "bean名称")
    private String beanName;

    /**
     * bean路径
     */
    @ApiModelProperty(value = "bean路径")
    private String beanPath;

    /**
     * 替代值
     */
    @ApiModelProperty(value = "替代值")
    private BigDecimal replacementValue;

    /**
     * 页面是否显示（字典）
     */
    @ApiModelProperty(value = "页面是否显示（字典）")
    private Integer showFlag;

    /**
     * 是否有效（字典）
     */
    @ApiModelProperty(value = "是否有效（字典）")
    private Integer effectiveFlag;

    /**
     * 显示顺序
     */
    @ApiModelProperty(value = "显示顺序")
    private Integer sortNum;
}