package com.biz.crm.base.config;

import com.biz.crm.nebular.mdm.dict.resp.DictGroupRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRedisVo;
import com.biz.crm.util.UserRedis;

import java.util.concurrent.ConcurrentHashMap;

/**
 * 当前用户本地变量
 */
public class ThreadLocalUtil {
    //本地用户
    protected static final ThreadLocal<UserRedis> userLocal = new ThreadLocal<>();
    //本地变量
    protected static final ThreadLocal<ConcurrentHashMap<String,Object>> threadLocalParam = new ThreadLocal<>();
    //本地请求参数
    protected static final ThreadLocal<String> parameterLocal = new ThreadLocal<>();
    //数据字典本地缓存
    protected static final ThreadLocal<ConcurrentHashMap<String, DictGroupRedisVo>> dictGroupLocal = new ThreadLocal<>();
    //数据字典无效类型编码锁定本地缓存
    protected static final ThreadLocal<ConcurrentHashMap<String, Long>> dictGroupKeyLockLocal = new ThreadLocal<>();

    //组织本地缓存
    protected static final ThreadLocal<ConcurrentHashMap<String, MdmOrgRedisVo>> orgSelfLocal = new ThreadLocal<>();
    //组织编码锁定本地缓存
    protected static final ThreadLocal<ConcurrentHashMap<String, Long>> orgCodeLockLocal = new ThreadLocal<>();

    public static UserRedis getUser(){
        return userLocal.get();
    }

    public static void setUser(UserRedis user){
        userLocal.set(user);
    }
    public static void deleteUser(){
        userLocal.remove();
    }



    public static Object getObj(String key){
        ConcurrentHashMap<String,Object> map=  threadLocalParam.get();
        if (map!=null){
            return map.get(key);
        }
        return null;
    }

    public static void stObj(ConcurrentHashMap<String,Object> map){
        threadLocalParam.set(map);
    }

    public static void delObj(){
        threadLocalParam.remove();
    }

    public static void setParameter(String parameter){
        parameterLocal.set(parameter);
    }

    public static String getParameter(){
        return parameterLocal.get();
    }

    public static void delParameter(){
        parameterLocal.remove();
    }

    /*----------------------------------数据字典本地缓存 start----------------------------------*/
    public static void addToDictGroup(String key, DictGroupRedisVo value) {
        if (value == null) {
            ConcurrentHashMap<String, Long> lockMap = dictGroupKeyLockLocal.get();
            if (lockMap == null) {
                lockMap = new ConcurrentHashMap<>(16);
            }
            lockMap.put(key, System.currentTimeMillis());
            dictGroupKeyLockLocal.set(lockMap);
        } else {
            ConcurrentHashMap<String, DictGroupRedisVo> groupMap = dictGroupLocal.get();
            if (groupMap == null) {
                groupMap = new ConcurrentHashMap<>(16);
            }
            groupMap.put(key, value);
            dictGroupLocal.set(groupMap);
        }
    }

    public static boolean dictGroupContains(String key) {
        ConcurrentHashMap<String, Long> lockMap = dictGroupKeyLockLocal.get();
        if (lockMap != null) {
            if (lockMap.containsKey(key)) {
                if (lockMap.get(key) - System.currentTimeMillis() >= 1000L * 2) {
                    lockMap.remove(key);
                    dictGroupKeyLockLocal.set(lockMap);
                } else {
                    return true;
                }
            }
        }
        if (lockMap == null || !lockMap.containsKey(key)) {
            ConcurrentHashMap<String, DictGroupRedisVo> groupMap = dictGroupLocal.get();
            if (groupMap != null && groupMap.containsKey(key)) {
                return true;
            }
        }
        return false;
    }

    public static DictGroupRedisVo getFromDictGroup(String key) {
        ConcurrentHashMap<String, DictGroupRedisVo> map = dictGroupLocal.get();
        if (map != null && map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static void delDict() {
        dictGroupLocal.remove();
        dictGroupKeyLockLocal.remove();
    }
    /*----------------------------------数据字典本地缓存 end----------------------------------*/


    /*----------------------------------组织本地缓存 start----------------------------------*/
    public static void addToOrgSelf(String key, MdmOrgRedisVo value) {
        if (value == null) {
            ConcurrentHashMap<String, Long> lockMap = orgCodeLockLocal.get();
            if (lockMap == null) {
                lockMap = new ConcurrentHashMap<>(16);
            }
            lockMap.put(key, System.currentTimeMillis());
            orgCodeLockLocal.set(lockMap);
        } else {
            ConcurrentHashMap<String, MdmOrgRedisVo> groupMap = orgSelfLocal.get();
            if (groupMap == null) {
                groupMap = new ConcurrentHashMap<>(16);
            }
            groupMap.put(key, value);
            orgSelfLocal.set(groupMap);
        }
    }

    public static boolean orgSelfContains(String key) {
        ConcurrentHashMap<String, Long> lockMap = orgCodeLockLocal.get();
        if (lockMap != null) {
            if (lockMap.containsKey(key)) {
                if (lockMap.get(key) - System.currentTimeMillis() >= 1000L * 2) {
                    lockMap.remove(key);
                    orgCodeLockLocal.set(lockMap);
                } else {
                    return true;
                }
            }
        }
        if (lockMap == null || !lockMap.containsKey(key)) {
            ConcurrentHashMap<String, MdmOrgRedisVo> groupMap = orgSelfLocal.get();
            if (groupMap != null && groupMap.containsKey(key)) {
                return true;
            }
        }
        return false;
    }

    public static MdmOrgRedisVo getFromOrgSelf(String key) {
        ConcurrentHashMap<String, MdmOrgRedisVo> map = orgSelfLocal.get();
        if (map != null && map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static void delOrg() {
        orgCodeLockLocal.remove();
        orgSelfLocal.remove();
    }
    /*----------------------------------组织本地缓存 end----------------------------------*/

    //清除线程信息
    public static void clear(){
        ThreadLocalUtil.deleteUser();
        ThreadLocalUtil.delObj();
        ThreadLocalUtil.delParameter();
        ThreadLocalUtil.delDict();
        ThreadLocalUtil.delOrg();
    }

}
