package com.biz.crm.nebular.dms.rebatefeepool;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.List;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 折扣费用池冻结明细
 * @Author: chenrong
 * @Date: 2020/12/17 11:26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel("折扣费用池冻结明细")
public class RebateFeePoolFrozenItemVo extends CrmExtVo {

  private static final long serialVersionUID = -2357929852247348386L;

  /**
   * 编码
   */
  @ApiModelProperty(value = "编码")
  private String code;
  /**
   * 折扣费用池编码
   */
  @ApiModelProperty(value = "折扣费用池编码")
  private String rebateFeePoolCode;
  /**
   * 冻结金额
   */
  @ApiModelProperty(value = "冻结金额")
  private BigDecimal frozenFee = BigDecimal.ZERO;
  /**
   * 已解冻金额
   */
  @ApiModelProperty(value = "已解冻金额")
  private BigDecimal unfrozenFee = BigDecimal.ZERO;
  /**
   * 剩余冻结金额
   */
  @ApiModelProperty(value = "剩余冻结金额")
  private BigDecimal remainFrozenFee = BigDecimal.ZERO;
  /**
   * 冻结原因
   */
  @ApiModelProperty(value = "冻结原因")
  private String frozenReason;
  /**
   * 附件列表
   */
  @ApiModelProperty(value = "附件列表")
  private List<RebateFeePoolFrozenFileVo> files;
  /**
   * 开始日期
   */
  @ApiModelProperty(value = "开始日期")
  private String startDate;
  /**
   * 结束日期
   */
  @ApiModelProperty(value = "结束日期")
  private String endDate;

  /**
   * 冗余字段：折扣费用池对象
   */
  @ApiModelProperty(value = "冗余字段：折扣费用池对象")
  private RebateFeePoolVo rebateFeePoolVo;

  /**
   * bpm编码
   */
  @ApiModelProperty(value = "bpm编码")
  private String bpmCode;

}
