package com.biz.crm.nebular.mdm.customer;

import com.biz.crm.common.ParamCheck;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelImport;

/**
 * 客户信息联系人信息导入
 * @author liaohua
 * @date 2020/10/15 3:43 下午
 */
@NebulaExcelImport(startRow = 1)
public class MdmCustomerContactImportExcelVo {

  /**
   * 客户编码
   */
  @NebulaExcelColumn(order = 0, title = "客户编码")
  @ParamCheck(isNotNull = true, msg = "客户编码不能为空")
  private String customerCode;

  /**
   * 联系人姓名
   */
  @NebulaExcelColumn(order = 1, title = "联系人姓名")
  @ParamCheck(isNotNull = true, msg = "联系人姓名不能为空")
  private String contactName;

  /**
   * 联系人电话
   */
  @NebulaExcelColumn(order = 2, title = "联系人电话")
  @ParamCheck(isNotNull = true, msg = "联系人电话不能为空")
  private String contactPhone;

  public String getCustomerCode() {
    return customerCode;
  }

  public void setCustomerCode(String customerCode) {
    this.customerCode = customerCode;
  }

  public String getContactName() {
    return contactName;
  }

  public void setContactName(String contactName) {
    this.contactName = contactName;
  }

  public String getContactPhone() {
    return contactPhone;
  }

  public void setContactPhone(String contactPhone) {
    this.contactPhone = contactPhone;
  }

  @Override
  public String toString() {
    return "MdmCustomerContactImportExcelVo{" +
        "customerCode='" + customerCode + '\'' +
        ", contactName='" + contactName + '\'' +
        ", contactPhone='" + contactPhone + '\'' +
        '}';
  }
}
