package com.biz.crm.nebular.activiti.design.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 返回vo
 *
 * @author jerry7
 * @date 2020-12-04 10:33:17
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "节点配置返回VO")
@SaturnEntity(name = "TaNodeConfigRespVo", description = "节点配置返回VO")
public class TaNodeConfigRespVo {
    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("流程节点ID")
    private String processNodeId;

    @ApiModelProperty("流程节点编码")
    private String processNodeCode;

    @ApiModelProperty("流程节点名称")
    private String processNodeName;

    @ApiModelProperty("审批角色")
    private String roleCode;

    @ApiModelProperty("带版本的流程定义KEY")
    private String processVersionKey;

    @ApiModelProperty("按钮权限角色ID")
    private String btnAuthRoleId;

    @ApiModelProperty("按钮权限角色名称")
    private String btnAuthRoleName;

    @ApiModelProperty("审批重复跳过 1-true  0-false")
    private Integer auditRepeatSkip;

    @ApiModelProperty("审批时 人员为空跳过   1-true  0-false")
    private Integer auditNullSkip;

    @ApiModelProperty("节点期限 0-表示无期限限制")
    private Integer nodeTimeout;

    @ApiModelProperty("是否允许退回")
    private Integer canBack;

    @ApiModelProperty("是否默认分配节点")
    private Integer isDefaultChoose;

    @ApiModelProperty("是否可以手动选择下一个节点(0=不能1=能)")
    private Integer manualNext;

    @ApiModelProperty("是否允许被分配")
    private Integer canDistribution;

    @ApiModelProperty("允许被指向")
    private Integer canPoint;

    @ApiModelProperty("是否是内部审批(0=否1=是)")
    private Integer configInside;

    @ApiModelProperty("指派参数")
    private String nodeParams;

    @ApiModelProperty("是否使用")
    private String state;

    @ApiModelProperty("撤销标识(0=否1=是),此节点标识为1，则流程之后的节点都不能撤销了")
    private Integer cancelFlag;

    @ApiModelProperty("配置审批类型")
    private String candidateType;

    @ApiModelProperty("审批值")
    private String candidateValue;

    @ApiModelProperty("审批人可见")
    private Integer userIsView;

    @ApiModelProperty("审批通过类型(0=普通1=最终审批2=审核3=复核4=财务审批)")
    private Integer approveType;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    @ApiModelProperty("")
    private String orgHierarchy;

    @ApiModelProperty("是否查看关联附件1是0否默认为1")
    private Integer viewRelation;

    @ApiModelProperty("是否开启动态节点1是0否")
    private Integer isAddFlow;

    @ApiModelProperty("流程名称")
    private String processName;

    @ApiModelProperty("表单角色")
    private String formRole;

}