package com.biz.crm.nebular.activiti.act.resp;

import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 返回vo
 *
 * @author jerry7
 * @date 2020-12-05 15:36:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "")
@SaturnEntity(name = "TaActBaseProcessRespVo", description = "")
public class TaActBaseProcessRespVo {

    @ApiModelProperty("id")
    private String id;

    @ApiModelProperty("")
    private String baseId;

    @ApiModelProperty("标题")
    private String title;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("发起人编码")
    private String applierCode;

    @ApiModelProperty("发起人名称")
    private String applierName;

    @ApiModelProperty("发起人职位")
    private String positionCode;

    @ApiModelProperty("职位名称")
    private String positionName;

    @ApiModelProperty("0=草稿1=暂存2=已提交3=已完成4=驳回5=终止6=撤销")
    private Integer status;

    @ApiModelProperty("流程状态名称")
    private String statusValue;

    @ApiModelProperty("")
    private String processKey;

    @ApiModelProperty("流程实例ID")
    private String processInstanceId;

    @ApiModelProperty("")
    private String parentProcessInstanceId;

    @ApiModelProperty("导致流程的原因类型(1=正常发起2=驳回3=转发=4加签5=子流程)")
    private Integer causeType;

    @ApiModelProperty("导致产生流程的职位")
    private String causePositionCode;

    @ApiModelProperty("导致产生流程的职位名称")
    private String causePositionName;

    @ApiModelProperty("导致产生流程的用户账号")
    private String causeUserCode;

    @ApiModelProperty("导致产生流程的用户名称")
    private String causeUserName;

    @ApiModelProperty("发起流程时间")

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    @ApiModelProperty("")
    private String formUrl;

    @ApiModelProperty("流程版本KEY")
    private String processVersionKey;

    @ApiModelProperty("静态HTML快照URL")
    private String htmlUrl;

    @ApiModelProperty("记录状态")
    private Integer availableStatus;

    @ApiModelProperty("记录状态名称")
    private String availableStatusValue;

    @ApiModelProperty("当前处理岗位编码")
    private String currentCode;

    @ApiModelProperty("当前处理岗位名称")
    private String currentName;

    @ApiModelProperty("当前处理人编码")
    private String currentUserCode;

    @ApiModelProperty("当前处理人名称")
    private String currentUserName;

    @ApiModelProperty("表单编号")
    private String formNo;

    @ApiModelProperty("流程名称")
    private String processName;

    @ApiModelProperty("业务类型")
    private String costType;

    @ApiModelProperty("业务编码")
    private String businessCode;

    @ApiModelProperty("任务耗时")
    private String consumingTime;
}