package com.biz.crm.nebular.fee.pool.req;

import com.bizunited.platform.common.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 折扣费用池添加上账请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolDiscountAccountReqVo", description = "折扣费用池添加上账请求VO")
public class FeePoolDiscountAccountReqVo extends UuidVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("审批状态")
    private String bpmStatus;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("折扣费用池类型")
    private String discountType;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("来源单号")
    private String fromCode;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("附件")
    private List<FeePoolFileReqVo> fileList;

    @ApiModelProperty("备注")
    private String remarks;

}