package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * 折扣费用池添加期初请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolDiscountInitAccountReqVo", description = "折扣费用池添加期初请求VO")
public class FeePoolDiscountInitAccountReqVo {

    @ApiModelProperty("审批状态")
    private String bpmStatus;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("折扣费用池类型")
    private String discountType;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("来源单号")
    private String fromCode;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("附件")
    private List<FeePoolFileReqVo> fileList;

    @ApiModelProperty("扩展字段1")
    private String ext1 = StringUtils.EMPTY;

    @ApiModelProperty("扩展字段2")
    private String ext2 = StringUtils.EMPTY;

    @ApiModelProperty("扩展字段3")
    private String ext3 = StringUtils.EMPTY;

    @ApiModelProperty("扩展字段4")
    private String ext4 = StringUtils.EMPTY;

    @ApiModelProperty("扩展字段5")
    private String ext5 = StringUtils.EMPTY;

    @ApiModelProperty("扩展字段6")
    private String ext6 = StringUtils.EMPTY;

    @ApiModelProperty("扩展字段7")
    private String ext7 = StringUtils.EMPTY;

    @ApiModelProperty("扩展字段8")
    private String ext8 = StringUtils.EMPTY;

    @ApiModelProperty("扩展字段9")
    private String ext9 = StringUtils.EMPTY;

    @ApiModelProperty("扩展字段10")
    private String ext10 = StringUtils.EMPTY;

}