/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.base.config;

import com.biz.crm.nebular.mdm.dict.resp.DictGroupRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRedisVo;
import com.biz.crm.util.UserRedis;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadLocalUtil {
    protected static final ThreadLocal<UserRedis> userLocal = new ThreadLocal();
    protected static final ThreadLocal<ConcurrentHashMap<String, Object>> threadLocalParam = new ThreadLocal();
    protected static final ThreadLocal<String> parameterLocal = new ThreadLocal();
    protected static final ThreadLocal<ConcurrentHashMap<String, DictGroupRedisVo>> dictGroupLocal = new ThreadLocal();
    protected static final ThreadLocal<ConcurrentHashMap<String, Long>> dictGroupKeyLockLocal = new ThreadLocal();
    protected static final ThreadLocal<ConcurrentHashMap<String, Long>> orgCodeLockLocal = new ThreadLocal();
    protected static final ThreadLocal<ConcurrentHashMap<String, MdmOrgRedisVo>> orgSelfLocal = new ThreadLocal();
    protected static final ThreadLocal<ConcurrentHashMap<String, MdmOrgParentChildrenRedisVo>> orgParentLocal = new ThreadLocal();
    protected static final ThreadLocal<ConcurrentHashMap<String, MdmOrgParentChildrenRedisVo>> orgChildrenLocal = new ThreadLocal();
    protected static final ThreadLocal<ConcurrentHashMap<String, Long>> positionCodeLockLocal = new ThreadLocal();
    protected static final ThreadLocal<ConcurrentHashMap<String, MdmPositionRedisVo>> positionSelfLocal = new ThreadLocal();
    protected static final ThreadLocal<ConcurrentHashMap<String, MdmPositionParentChildrenRedisVo>> positionParentLocal = new ThreadLocal();
    protected static final ThreadLocal<ConcurrentHashMap<String, MdmPositionParentChildrenRedisVo>> positionChildrenLocal = new ThreadLocal();

    public static UserRedis getUser() {
        return userLocal.get();
    }

    public static void setUser(UserRedis user) {
        userLocal.set(user);
    }

    public static void deleteUser() {
        userLocal.remove();
    }

    public static Object getObj(String key) {
        ConcurrentHashMap<String, Object> map = threadLocalParam.get();
        if (map != null) {
            return map.get(key);
        }
        return null;
    }

    public static void stObj(ConcurrentHashMap<String, Object> map) {
        threadLocalParam.set(map);
    }

    public static void delObj() {
        threadLocalParam.remove();
    }

    public static void setParameter(String parameter) {
        parameterLocal.set(parameter);
    }

    public static String getParameter() {
        return parameterLocal.get();
    }

    public static void delParameter() {
        parameterLocal.remove();
    }

    public static void addToDictGroup(String key, DictGroupRedisVo value) {
        if (value == null) {
            ConcurrentHashMap<String, Long> lockMap = dictGroupKeyLockLocal.get();
            if (lockMap == null) {
                lockMap = new ConcurrentHashMap(16);
            }
            lockMap.put(key, System.currentTimeMillis());
            dictGroupKeyLockLocal.set(lockMap);
        } else {
            ConcurrentHashMap<String, DictGroupRedisVo> groupMap = dictGroupLocal.get();
            if (groupMap == null) {
                groupMap = new ConcurrentHashMap(16);
            }
            groupMap.put(key, value);
            dictGroupLocal.set(groupMap);
        }
    }

    public static boolean dictGroupContains(String key) {
        ConcurrentHashMap<String, DictGroupRedisVo> groupMap;
        ConcurrentHashMap<String, Long> lockMap = dictGroupKeyLockLocal.get();
        if (lockMap != null && lockMap.containsKey(key)) {
            if (lockMap.get(key) - System.currentTimeMillis() >= 2000L) {
                lockMap.remove(key);
                dictGroupKeyLockLocal.set(lockMap);
            } else {
                return true;
            }
        }
        return (lockMap == null || !lockMap.containsKey(key)) && (groupMap = dictGroupLocal.get()) != null && groupMap.containsKey(key);
    }

    public static DictGroupRedisVo getFromDictGroup(String key) {
        ConcurrentHashMap<String, DictGroupRedisVo> map = dictGroupLocal.get();
        if (map != null && map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static void delDict() {
        dictGroupLocal.remove();
        dictGroupKeyLockLocal.remove();
    }

    public static void addToOrgSelf(String key, MdmOrgRedisVo value) {
        if (value == null) {
            ConcurrentHashMap<String, Long> lockMap = orgCodeLockLocal.get();
            if (lockMap == null) {
                lockMap = new ConcurrentHashMap(16);
            }
            lockMap.put(key, System.currentTimeMillis());
            orgCodeLockLocal.set(lockMap);
        } else {
            ConcurrentHashMap<String, MdmOrgRedisVo> groupMap = orgSelfLocal.get();
            if (groupMap == null) {
                groupMap = new ConcurrentHashMap(16);
            }
            groupMap.put(key, value);
            orgSelfLocal.set(groupMap);
        }
    }

    public static boolean orgSelfContains(String key) {
        ConcurrentHashMap<String, MdmOrgRedisVo> groupMap;
        ConcurrentHashMap<String, Long> lockMap = orgCodeLockLocal.get();
        if (lockMap != null && lockMap.containsKey(key)) {
            if (lockMap.get(key) - System.currentTimeMillis() >= 2000L) {
                lockMap.remove(key);
                orgCodeLockLocal.set(lockMap);
            } else {
                return true;
            }
        }
        return (lockMap == null || !lockMap.containsKey(key)) && (groupMap = orgSelfLocal.get()) != null && groupMap.containsKey(key);
    }

    public static MdmOrgRedisVo getFromOrgSelf(String key) {
        ConcurrentHashMap<String, MdmOrgRedisVo> map = orgSelfLocal.get();
        if (map != null && map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static void addToOrgParent(String key, MdmOrgParentChildrenRedisVo value) {
        if (value == null) {
            ConcurrentHashMap<String, Long> lockMap = orgCodeLockLocal.get();
            if (lockMap == null) {
                lockMap = new ConcurrentHashMap(16);
            }
            lockMap.put(key, System.currentTimeMillis());
            orgCodeLockLocal.set(lockMap);
        } else {
            ConcurrentHashMap<String, MdmOrgParentChildrenRedisVo> groupMap = orgParentLocal.get();
            if (groupMap == null) {
                groupMap = new ConcurrentHashMap(16);
            }
            groupMap.put(key, value);
            orgParentLocal.set(groupMap);
        }
    }

    public static boolean orgParentContains(String key) {
        ConcurrentHashMap<String, MdmOrgParentChildrenRedisVo> groupMap;
        ConcurrentHashMap<String, Long> lockMap = orgCodeLockLocal.get();
        if (lockMap != null && lockMap.containsKey(key)) {
            if (lockMap.get(key) - System.currentTimeMillis() >= 2000L) {
                lockMap.remove(key);
                orgCodeLockLocal.set(lockMap);
            } else {
                return true;
            }
        }
        return (lockMap == null || !lockMap.containsKey(key)) && (groupMap = orgParentLocal.get()) != null && groupMap.containsKey(key);
    }

    public static MdmOrgParentChildrenRedisVo getFromOrgParent(String key) {
        ConcurrentHashMap<String, MdmOrgParentChildrenRedisVo> map = orgParentLocal.get();
        if (map != null && map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static void addToOrgChildren(String key, MdmOrgParentChildrenRedisVo value) {
        if (value == null) {
            ConcurrentHashMap<String, Long> lockMap = orgCodeLockLocal.get();
            if (lockMap == null) {
                lockMap = new ConcurrentHashMap(16);
            }
            lockMap.put(key, System.currentTimeMillis());
            orgCodeLockLocal.set(lockMap);
        } else {
            ConcurrentHashMap<String, MdmOrgParentChildrenRedisVo> groupMap = orgChildrenLocal.get();
            if (groupMap == null) {
                groupMap = new ConcurrentHashMap(16);
            }
            groupMap.put(key, value);
            orgChildrenLocal.set(groupMap);
        }
    }

    public static boolean orgChildrenContains(String key) {
        ConcurrentHashMap<String, MdmOrgParentChildrenRedisVo> groupMap;
        ConcurrentHashMap<String, Long> lockMap = orgCodeLockLocal.get();
        if (lockMap != null && lockMap.containsKey(key)) {
            if (lockMap.get(key) - System.currentTimeMillis() >= 2000L) {
                lockMap.remove(key);
                orgCodeLockLocal.set(lockMap);
            } else {
                return true;
            }
        }
        return (lockMap == null || !lockMap.containsKey(key)) && (groupMap = orgChildrenLocal.get()) != null && groupMap.containsKey(key);
    }

    public static MdmOrgParentChildrenRedisVo getFromOrgChildren(String key) {
        ConcurrentHashMap<String, MdmOrgParentChildrenRedisVo> map = orgChildrenLocal.get();
        if (map != null && map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static void delOrg() {
        orgCodeLockLocal.remove();
        orgSelfLocal.remove();
        orgParentLocal.remove();
        orgChildrenLocal.remove();
    }

    public static void addToPositionSelf(String key, MdmPositionRedisVo value) {
        if (value == null) {
            ConcurrentHashMap<String, Long> lockMap = positionCodeLockLocal.get();
            if (lockMap == null) {
                lockMap = new ConcurrentHashMap(16);
            }
            lockMap.put(key, System.currentTimeMillis());
            positionCodeLockLocal.set(lockMap);
        } else {
            ConcurrentHashMap<String, MdmPositionRedisVo> groupMap = positionSelfLocal.get();
            if (groupMap == null) {
                groupMap = new ConcurrentHashMap(16);
            }
            groupMap.put(key, value);
            positionSelfLocal.set(groupMap);
        }
    }

    public static boolean positionSelfContains(String key) {
        ConcurrentHashMap<String, MdmPositionRedisVo> groupMap;
        ConcurrentHashMap<String, Long> lockMap = positionCodeLockLocal.get();
        if (lockMap != null && lockMap.containsKey(key)) {
            if (lockMap.get(key) - System.currentTimeMillis() >= 2000L) {
                lockMap.remove(key);
                positionCodeLockLocal.set(lockMap);
            } else {
                return true;
            }
        }
        return (lockMap == null || !lockMap.containsKey(key)) && (groupMap = positionSelfLocal.get()) != null && groupMap.containsKey(key);
    }

    public static MdmPositionRedisVo getFromPositionSelf(String key) {
        ConcurrentHashMap<String, MdmPositionRedisVo> map = positionSelfLocal.get();
        if (map != null && map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static void addToPositionParent(String key, MdmPositionParentChildrenRedisVo value) {
        if (value == null) {
            ConcurrentHashMap<String, Long> lockMap = positionCodeLockLocal.get();
            if (lockMap == null) {
                lockMap = new ConcurrentHashMap(16);
            }
            lockMap.put(key, System.currentTimeMillis());
            positionCodeLockLocal.set(lockMap);
        } else {
            ConcurrentHashMap<String, MdmPositionParentChildrenRedisVo> groupMap = positionParentLocal.get();
            if (groupMap == null) {
                groupMap = new ConcurrentHashMap(16);
            }
            groupMap.put(key, value);
            positionParentLocal.set(groupMap);
        }
    }

    public static boolean positionParentContains(String key) {
        ConcurrentHashMap<String, MdmPositionParentChildrenRedisVo> groupMap;
        ConcurrentHashMap<String, Long> lockMap = positionCodeLockLocal.get();
        if (lockMap != null && lockMap.containsKey(key)) {
            if (lockMap.get(key) - System.currentTimeMillis() >= 2000L) {
                lockMap.remove(key);
                positionCodeLockLocal.set(lockMap);
            } else {
                return true;
            }
        }
        return (lockMap == null || !lockMap.containsKey(key)) && (groupMap = positionParentLocal.get()) != null && groupMap.containsKey(key);
    }

    public static MdmPositionParentChildrenRedisVo getFromPositionParent(String key) {
        ConcurrentHashMap<String, MdmPositionParentChildrenRedisVo> map = positionParentLocal.get();
        if (map != null && map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static void addToPositionChildren(String key, MdmPositionParentChildrenRedisVo value) {
        if (value == null) {
            ConcurrentHashMap<String, Long> lockMap = positionCodeLockLocal.get();
            if (lockMap == null) {
                lockMap = new ConcurrentHashMap(16);
            }
            lockMap.put(key, System.currentTimeMillis());
            positionCodeLockLocal.set(lockMap);
        } else {
            ConcurrentHashMap<String, MdmPositionParentChildrenRedisVo> groupMap = positionChildrenLocal.get();
            if (groupMap == null) {
                groupMap = new ConcurrentHashMap(16);
            }
            groupMap.put(key, value);
            positionChildrenLocal.set(groupMap);
        }
    }

    public static boolean positionChildrenContains(String key) {
        ConcurrentHashMap<String, MdmPositionParentChildrenRedisVo> groupMap;
        ConcurrentHashMap<String, Long> lockMap = positionCodeLockLocal.get();
        if (lockMap != null && lockMap.containsKey(key)) {
            if (lockMap.get(key) - System.currentTimeMillis() >= 2000L) {
                lockMap.remove(key);
                positionCodeLockLocal.set(lockMap);
            } else {
                return true;
            }
        }
        return (lockMap == null || !lockMap.containsKey(key)) && (groupMap = positionChildrenLocal.get()) != null && groupMap.containsKey(key);
    }

    public static MdmPositionParentChildrenRedisVo getFromPositionChildren(String key) {
        ConcurrentHashMap<String, MdmPositionParentChildrenRedisVo> map = positionChildrenLocal.get();
        if (map != null && map.containsKey(key)) {
            return map.get(key);
        }
        return null;
    }

    public static void delPosition() {
        positionCodeLockLocal.remove();
        positionSelfLocal.remove();
        positionParentLocal.remove();
        positionChildrenLocal.remove();
    }

    public static void clear() {
        ThreadLocalUtil.deleteUser();
        ThreadLocalUtil.delObj();
        ThreadLocalUtil.delParameter();
        ThreadLocalUtil.delDict();
        ThreadLocalUtil.delOrg();
        ThreadLocalUtil.delPosition();
    }
}

