/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.util;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    private static final String EMPTY_REGEX = "[\\s\\u00a0\\u2007\\u202f\\u0009-\\u000d\\u001c-\\u001f]+";
    private static final String NUM_REG = "(\\+|\\-)?\\s*\\d+(\\.\\d+)?";
    private static final String PUNCT_REG = "[^a-zA-Z0-9\\u4e00-\\u9fa5]";

    private StringUtils() {
    }

    public static String formatNull(String src) {
        return src == null || "null".equals(src) ? "" : src;
    }

    public static boolean isEmpty(String input) {
        return input == null || input.equals("") || input.matches(EMPTY_REGEX);
    }

    public static boolean isNotEmpty(String input) {
        return !StringUtils.isEmpty(input);
    }

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String toUpperCaseFirstOne(String s) {
        if (Character.isUpperCase(s.charAt(0))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static boolean isNumber(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return str.trim().matches(NUM_REG);
    }

    public static boolean containUnreadableCode(String str) {
        return StringUtils.contain(str, "\\ufffd");
    }

    public static boolean containNumber(String str) {
        return StringUtils.contain(str, "\\d");
    }

    public static boolean containWord(String str) {
        return StringUtils.contain(str, "\\w");
    }

    public static boolean containPunct(String str) {
        return StringUtils.contain(str, PUNCT_REG);
    }

    public static boolean contain(String str, String regex) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(regex)) {
            return false;
        }
        if (str.trim().matches(regex)) {
            return true;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public static String replaceAll(String input, String regex, String replacement) {
        return Pattern.compile(regex, 2).matcher(input).replaceAll(replacement);
    }

    public static String removeAllSpace(String text) {
        if (StringUtils.isEmpty(text)) {
            return text;
        }
        return text.replaceAll("[ ]+", "");
    }

    public static String removeAllPunct(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        return str.replaceAll(PUNCT_REG, "");
    }

    public static int countMatches(String str, String sub) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(sub)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            ++count;
            idx += sub.length();
        }
        return count;
    }

    public static String substring(String str, int beginIndex, int endIndex) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int length = str.length();
        if (beginIndex >= length || endIndex <= 0 || beginIndex >= endIndex) {
            return null;
        }
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex > length) {
            endIndex = length;
        }
        return str.substring(beginIndex, endIndex);
    }

    public static Set<String> substring(String str, String sub) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(sub)) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        int idx = 0;
        while ((idx = str.indexOf(sub, idx)) != -1) {
            String temp = StringUtils.substring(str, idx - 1, idx + sub.length());
            if (!(StringUtils.isEmpty(temp) || sub.equalsIgnoreCase(temp = StringUtils.removeAllPunct(temp)) || StringUtils.containWord(temp))) {
                result.add(temp);
            }
            if (!(StringUtils.isEmpty(temp = StringUtils.substring(str, idx, idx + sub.length() + 1)) || sub.equalsIgnoreCase(temp = StringUtils.removeAllPunct(temp)) || StringUtils.containWord(temp))) {
                result.add(temp);
            }
            idx += sub.length();
        }
        return result;
    }

    public static String wrapXmlContent(String content) {
        if (StringUtils.isEmpty(content)) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char ch = content.charAt(i);
            if (!(ch == '\t' || ch == '\n' || ch == '\r' || ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd') && (ch < '\u10000' || ch > '\u10ffff')) continue;
            result.append(ch);
        }
        return result.toString();
    }

    public static boolean overLength(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        return str.length() > 1;
    }

    public static String specialStr(String str) {
        str = str.replaceAll("[^\\u4e00-\\u9fa5 | 0-9| a-zA-Z | \\.]+", " ").replaceAll("[\\.]{2,}", " ").trim();
        return str;
    }

    public static String replaceInValidateChar(String str) {
        return str.replaceAll("[^a-zA-Z0-9\\u4e00-\\u9fa5\\s+]", " ");
    }

    public static String[] toHexString(String str) {
        char[] chars = str.toCharArray();
        String[] result = new String[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            result[i] = Integer.toHexString(chars[i]);
        }
        return result;
    }

    public static String getUuid() {
        return UUID.randomUUID().toString();
    }

    public static boolean isUrl(String src) {
        String regex = "http[s]?:\\/\\/([\\w-]+\\.[\\w-]+)(\\.[\\w-])+(:\\d{2,10})?.*";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(src);
        return matcher.matches();
    }

    public static String escapeSql(String str) {
        if (StringUtils.isNotEmpty(str)) {
            StringBuffer strbuff = new StringBuffer();
            for (String s : str.split("")) {
                if (s.equals("%") || s.equals("_") || s.equals("\\")) {
                    strbuff.append("\\");
                }
                strbuff.append(s);
            }
            return strbuff.toString();
        }
        return str;
    }
}

