package com.biz.crm.nebular.fee.pool.req;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 费用池操作记录表请求vo
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolOperationReqVo", description = "费用池操作记录表")
public class FeePoolOperationReqVo extends CrmBaseVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("费用池编号")
    private String operationCode;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("来源编号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("支付方式")
    private String payType;

    @ApiModelProperty("操作金额")
    private BigDecimal operationAmount;

    @ApiModelProperty("金额权重 1或者-1")
    private BigDecimal amountWeight;

}