package com.biz.crm.nebular.fee.pool.resp;

import com.biz.crm.nebular.mdm.CrmBaseVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 费用池上账明细表返回vo
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "费用池明细表")
@SaturnEntity(name = "FeePoolDetailRespVo", description = "费用池明细表")
public class FeePoolDetailRespVo extends CrmBaseVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("费用池明细编号")
    private String poolDetailCode;

    @ApiModelProperty("操作记录编号")
    private String operationCode;

    @ApiModelProperty("上账类型")
    private String operationType;

    @ApiModelProperty("来源编号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("支付方式")
    private String payType;

    @ApiModelProperty("上账时间yyyy-MM-dd HH:mm:ss")
    private String accountDateTime;

    @ApiModelProperty("上账金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("冻结金额")
    private BigDecimal freezeAmount;

    @ApiModelProperty("已使用")
    private BigDecimal useAmount;

    @ApiModelProperty("剩余可使用金额")
    private BigDecimal usableAmount;

    @ApiModelProperty("附件")
    private List<FeePoolFileRespVo> fileList;
}