package com.biz.crm.nebular.mdm.user.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 用户下拉框查询请求VO
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MdmUserSelectReqVo", description = "用户下拉框查询请求VO")
public class MdmUserSelectReqVo {

    @ApiModelProperty("返回条数，不传返回默认条数")
    private Integer pageSize;

    @ApiModelProperty("生效状态 003停用，009启用")
    private String enableStatus;

    @ApiModelProperty("用户登录名：模糊查询")
    private String userName;

    @ApiModelProperty("用户姓名：模糊查询")
    private String fullName;

    @Deprecated
    @ApiModelProperty("用户编码：模糊查询")
    private String userCode;

    @ApiModelProperty("用户类型：精确查询")
    private String userType;

    @ApiModelProperty("性别：精确查询")
    private String gender;

    @ApiModelProperty("锁定状态：精确查询")
    private String lockState;

    @ApiModelProperty("回显编码，字符串，一般用于单选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这条数据")
    private String selectedCode;

    @ApiModelProperty("回显编码集合，字符串数组，一般用于多选，如果编码对应的数据满足筛选条件，则返回结果集合一定包含这些数据")
    private List<String> selectedCodeList;

}