package com.biz.crm.nebular.sfa.visitstep.req;

import com.biz.crm.nebular.mdm.CrmExtVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;
/**
 * 拜访步骤(活动执行);请求vo
 *
 * @author liuhongming
 * @date 2020-10-13 15:58:45
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "SfaVisitStepActivityReqVo", description = "拜访步骤(活动执行);")
public class SfaVisitStepActivityReqVo extends CrmExtVo {

    @ApiModelProperty("ID集合")
    private List<String> ids;

    @ApiModelProperty("拜访编码")
    private String visitId;

    @ApiModelProperty("网点id")
    private String clientId;

    @ApiModelProperty("网点编码")
    private String clientCode;

    @ApiModelProperty("网点名称")
    private String clientName;

    @ApiModelProperty("网点类型")
    private String clientType;

    @ApiModelProperty("活动类型")
    private String actType;

    @ApiModelProperty("活动编码")
    private String actCode;

    @ApiModelProperty("活动名称")
    private String actName;

    @ApiModelProperty("活动开始时间")
    private String beginDate;

    @ApiModelProperty("活动结束时间")
    private String endDate;

    @ApiModelProperty("活动执行频率(陈列活动)")
    private String actFrequency;

    @ApiModelProperty("活动要求、描述")
    private String actRequire;

    @ApiModelProperty("预估销售额(费用活动)")
    private BigDecimal predictSales;

    @ApiModelProperty("金额(费用活动)")
    private BigDecimal amount;

    @ApiModelProperty("客户编码(费用活动)")
    private String customerCode;

    @ApiModelProperty("客户名称(费用活动)")
    private String customerName;


}