package com.biz.crm.nebular.fee.pool.req;

import com.biz.crm.nebular.mdm.CrmExtTenVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

/**
 * 费用池明细列表请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolDetailPageReqVo", description = "费用池明细列表请求VO")
public class FeePoolDetailPageReqVo extends CrmExtTenVo {

    @ApiModelProperty("费用池编号")
    private String poolCode;

    @ApiModelProperty("费用池明细编号")
    private String poolDetailCode;

    @ApiModelProperty("审批状态")
    private String bpmStatus;

    @ApiModelProperty("操作记录编号")
    private String operationCode;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("来源编号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("支付方式")
    private String payType;

    @ApiModelProperty("上账时间yyyy-MM-dd HH:mm:ss")
    private String accountDateTime;

    @ApiModelProperty("总金额")
    private BigDecimal totalAmount;

    @ApiModelProperty("冻结金额")
    private BigDecimal freezeAmount;

    @ApiModelProperty("已使用")
    private BigDecimal useAmount;

    @ApiModelProperty("剩余可使用金额")
    private BigDecimal usableAmount;

    @ApiModelProperty("费用池类型")
    private String poolType;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("渠道类型")
    private String channelType;

    @ApiModelProperty("组织编码(可能是集合，英文逗号间隔)")
    private String orgCode;

    @ApiModelProperty("组织名称(可能是集合，英文逗号间隔)")
    private String orgName;

    @ApiModelProperty("折扣费用池类型")
    private String discountType;

    @ApiModelProperty("货补产品层级编码")
    private String goodsProductLevelCode;

    @ApiModelProperty("货补产品层级名称")
    private String goodsProductLevelName;

    @ApiModelProperty("货补商品编码(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductCode;

    @ApiModelProperty("货补商品名称(可能是集合，排序之后，英文逗号间隔)")
    private String goodsProductName;

}