package com.biz.crm.nebular.mdm.permission;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

/**
 * 数据权限返回vo
 *
 * @author zxw
 * @date 2020-10-26 12:09:31
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "数据权限查询方式")
@SaturnEntity(name = "MdmPermissionSearchTypeRespVo", description = "数据权限查询方式")
@AllArgsConstructor
@NoArgsConstructor
public class MdmPermissionSearchTypeVo{

    @ApiModelProperty("权限对象编码")
    @SaturnColumn(description = "权限对象编码")
    private String permissionObjCode;

    @ApiModelProperty("权限对象名称")
    @SaturnColumn(description = "权限对象名称")
    private String permissionObjName;

    @ApiModelProperty("查询方式类型")
    @SaturnColumn(description = "查询方式类型")
    private String permissionSearchType;

    @ApiModelProperty("查询方式名称")
    @SaturnColumn(description = "查询方式名称")
    private String permissionSearchTypeName;

}