package com.biz.crm.nebular.fee.pool.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 折扣费用池使用金额请求VO
 *
 * @author Tao.Chen
 * @date 2021-01-20 13:44:35
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "FeePoolDiscountUseByPoolDetailCodeReqVo", description = "折扣费用池使用金额请求VO")
public class FeePoolDiscountUseByPoolDetailCodeReqVo {

    @ApiModelProperty("费用池明细编号")
    private String poolDetailCode;

    @ApiModelProperty("费用池明细编号集合")
    private List<String> poolDetailCodeList;

    @ApiModelProperty("使用金额")
    private BigDecimal amount;

    @ApiModelProperty("来源单号")
    private String fromCode;

    @ApiModelProperty("来源描述")
    private String fromDesc;

    @ApiModelProperty("操作类型")
    private String operationType;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("附件")
    private List<FeePoolFileReqVo> fileList;
}