package com.biz.crm.nebular.sfa.visitstep.resp;

import com.biz.crm.nebular.mdm.CrmExtVo;
import com.biz.crm.nebular.sfa.picture.resp.SfaVisitPictureRespVo;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumnRelation;
import com.bizunited.platform.saturn.engine.annotation.SaturnEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * 陈列执行返回vo
 *
 * @Author Tao.Chen
 * @Date 2020/10/21 15:49
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "陈列执行")
@SaturnEntity(name = "SfaVisitStepDisplayRespVo", description = "陈列执行")
public class SfaVisitStepDisplayRespVo extends CrmExtVo {

    @ApiModelProperty("标签名称")
    @SaturnColumn(description = "标签名称")
    private String labelName;

    @ApiModelProperty("标签描述")
    @SaturnColumn(description = "标签描述")
    private String labelDesc;

    @ApiModelProperty("照片数量要求")
    @SaturnColumn(description = "照片数量要求")
    private Integer picLimit;

    @ApiModelProperty("照片类型")
    @SaturnColumn(description = "照片类型")
    private String picType;

    @ApiModelProperty("图片列表")
    @SaturnColumnRelation(type = SaturnColumnRelation.RelationType.OneToMany)
    @SaturnColumn(description = "图片列表")
    private List<SfaVisitPictureRespVo> pictureList;

}